#!/usr/local/bin/perl
# 
# $Header: crs_resources.pl 30-mar-2005.15:33:00 hying Exp $
#
# crs_resources.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      crs_resources.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hying       03/30/05 - 4263092, review changes 
#    hying       01/10/05 - hying_crs_metrics
#    hying       12/30/04 - Creation
# 
require "emd_common.pl";
require "semd_common.pl";
                                                                                            
my $crs_home = shift(@ARGV); # CRSHome
if ($crs_home eq "")
{
  exit 0;
}
my $node_name = shift(@ARGV); # NodeName
                                                                                            
#################################
# View testing required ENV
#$ENV{ORA_CRS_HOME} = $crs_home;
#$ENV{LD_LIBRARY_PATH} = "$crs_home/lib:$ENV{LD_LIBRARY_PATH}";
#$ENV{OCR_LOC} = "/etc/oracle/ocr.loc";
#$ENV{OCR_DEVELOPER_ENV}="true";
#################################
                                                                                            
$cmd = "$crs_home/bin/crs_stat";
$result = `$cmd`;

my @lines = split(/\n/, $result);
my $i = 0;
my ($var, $val, $resource, $original_host, $current_host, $state, $on, $status);
                                                                                            
NAME_LOOP: while ($i < $#lines)
{
  ($var, $val) = split(/=/, $lines[$i]);
  if ($var eq "NAME")
  {
    $resource = $val;
    if ($val =~ /ora.(\w+).gsd$/ || $val =~ /ora.(\w+).ons$/)
    {
      if ($node_name eq $1)
      {
        while ($i < $#lines)
        {
          $i++;
          ($var, $val) = split(/=/, $lines[$i]);
          if ($var eq "TARGET")
          {
            $target = $val;
            debug("$var status: $target");
            $i++;
            ($var, $val) = split(/=/, $lines[$i]);
            $state = $val;
            debug("$var status: $state");
            if ($target eq "ONLINE" && $state eq "OFFLINE")
            {
              printf "em_result=$resource|OFFLINE NOT RESTARTING\n";
              debug("em_result=$resource|OFFLINE NOT RESTARTING\n");
            }
            else
            {
              printf "em_result=$resource|$state\n";
              debug("em_result=$resource|$state\n");
            }
            next NAME_LOOP;
          }
        }
      }
    }
    elsif ($val =~ /ora.(\w+).vip$/)
    {
      $original_host = $1;
      while ($i < $#lines)
      {
        $i++;
        ($var, $val) = split(/=/, $lines[$i]);
        if ($var eq "TARGET")
        {
          $target = $val;
          $i++;
          ($var, $val) = split(/=/, $lines[$i]);
          ($state, $on, $current_host) = split(/ /, $val);
          if ($node_name eq $current_host)
          {
            if ($target eq "ONLINE" && $state eq "OFFLINE")
            {
              printf "em_result=$resource|OFFLINE NOT RESTARTING\n";
              debug("em_result=$resource|OFFLINE NOT RESTARTING\n");
            }
            else
            {
              printf "em_result=$resource|$state\n";
              debug("em_result=$resource|$state\n");
            }
          }
          next NAME_LOOP;
        }
      }
    }
  }
  $i++;
}
                                                                                            
sub debug
{
  my ($line) = @_;
  EMD_PERL_DEBUG("$line");
}
                                                                                            
exit 0

