#!/usr/local/bin/perl
# 
# $Header: crs_vip.pl 14-sep-2005.16:36:17 hying Exp $
#
# crs_vip.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      crs_vip.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hying       09/13/05 - alert on one node, clear on all 
#    hying       07/26/05 - 4518389, collect all vips on each node 
#    hying       01/10/05 - hying_crs_metrics
#    hying       12/30/04 - Creation
# 
require "emd_common.pl";
require "semd_common.pl";
                                                                                            
my $crs_home = shift(@ARGV); # CRSHome
if ($crs_home eq "")
{
  exit 0;
}
my $node_name = shift(@ARGV); # NodeName

#################################
# View testing required ENV
#$ENV{OCR_LOC} = "/etc/oracle/ocr.loc";
#$ENV{OCR_DEVELOPER_ENV}="true";
#$ENV{ORA_CRS_HOME} = $crs_home;
#$ENV{LD_LIBRARY_PATH} = "$crs_home/lib:$ENV{LD_LIBRARY_PATH}";
#################################
                                                                                            
my $cmd = "$crs_home/bin/crs_stat";
my $result = `$cmd`;
                                                                                                                                
my @lines = split(/\n/, $result);
                                                                                                                                
my $i = 0;
my ($var, $val, $resource, $original_host, $current_host, $state, $on, $relocated);
                                                                                            
while ($i < $#lines)
{
  ($var, $val) = split(/=/, $lines[$i]);
  if ($var eq "NAME")
  {
    debug("Resource name: $val");
    $resource = $val;
    if ($val =~ /ora.(\w+).vip$/)
    {
      $original_host = $1;
      while ($i < $#lines)
      {
        $i++;
        ($var, $val) = split(/=/, $lines[$i]);
        if ($var eq "STATE")
        {
          ($state, $on, $current_host) = split(/ /, $val);
          debug("Current host: $current_host");
          $relocated = ($original_host ne $current_host)? 'TRUE':'FALSE';
          if ($relocated eq 'TRUE' && $node_name eq $current_host)
          {
            printf "em_result=$resource|$relocated|$current_host\n";
            debug("em_result=$resource|$relocated|$current_host\n");
          }
          else
          {
            printf "em_result=$resource|FALSE|$current_host\n";
            debug("em_result=$resource|FALSE|$current_host\n");
          }
          last;
        }
      }
    }
  }
  $i++;
}
                                                                                            
sub debug
{
  my ($line) = @_;
  EMD_PERL_DEBUG("$line");
}
                                                                                            
exit 0

