#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/db/cell/collectCellPatches.pl /main/3 2012/11/15 11:11:47 jsutton Exp $
#
# collectCellPatches.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      collectCellPatches.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsutton     11/13/12 - skip em_error lines
#    nmittal     05/07/11 - XbranchMerge nmittal_bug-12433444 from
#                           st_emll_10.3.5
#    nmittal     05/06/11 - bug 12433444
#    davili      04/27/11 - Creation
# 

# To process the list of patches, we create a temporary file where 
# the comma separated patch values are divided into individual rows.
# For example, we modify the following sample:
# cell_patches&192.168.74.186:Begin
# em_result=123,456,789
# cell_patches&192.168.74.186:End
#
# with:
# em_result=123|123
# em_result=456|456
# em_result=789|89

use strict;
use encoding 'utf8';

require "$ENV{EMDROOT}/sysman/admin/scripts/emd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/ccr/ccr_common.pl";

my ($configFile) = @ARGV;

my $metric = $ENV{Metric};
my $columnCount = $ENV{MetricColumnCount};
my $ip = $ENV{IP};

sub printPatchResult
{
  my ($result) = @_;

  if(length($result) != 0 && !($result =~ /^em_error=/))
  {
    $result =~ s/em_result=//; # remove the em_result= string
    my @patches = split(/,/ , $result);
    foreach (@patches)
    {
      my $bug_num = $_;
      my $output = "em_result=$bug_num|$bug_num";
      print "$output\n";
      EMD_PERL_INFO("Printed:$output");
    }
  }
}

handleCellMetricResult($configFile,$metric,$columnCount,$ip,\&printPatchResult);
