set serveroutput on;
set echo on;

--- drop sql response related objects
DROP TABLE dbsnmp.mgmt_snapshot;
DROP TABLE dbsnmp.mgmt_snapshot_sql;
DROP TABLE dbsnmp.mgmt_baseline;
DROP TABLE dbsnmp.mgmt_baseline_sql;
DROP TABLE dbsnmp.mgmt_capture;
DROP TABLE dbsnmp.mgmt_capture_sql;
DROP TABLE dbsnmp.mgmt_response_config;
DROP TABLE dbsnmp.mgmt_tempt_sql;
DROP TABLE dbsnmp.mgmt_latest;
DROP TABLE dbsnmp.mgmt_latest_sql;
DROP TABLE dbsnmp.mgmt_history;
DROP TABLE dbsnmp.mgmt_history_sql;
DROP SEQUENCE dbsnmp.mgmt_response_capture_id;
DROP SEQUENCE dbsnmp.mgmt_response_snapshot_id;
DROP VIEW dbsnmp.mgmt_response_baseline;
DROP PACKAGE BODY dbsnmp.mgmt_response;
DROP PACKAGE dbsnmp.mgmt_response;

--- kill perfstat sessions
DECLARE
  v VARCHAR2(200);
BEGIN
  FOR rec IN (
    SELECT 'ALTER SYSTEM KILL SESSION ''' || sid || ',' || serial# || '''' sess
      FROM v$session WHERE username = 'PERFSTAT')
    LOOP
      BEGIN
        v := rec.sess;
	  dbms_output.put_line(v);
        execute immediate v;
      EXCEPTION
        when others then
        dbms_output.put_line(SQLERRM);
      END;
   END LOOP;
  EXCEPTION
    when others then
      dbms_output.put_line(SQLERRM);
 END;
/


