# $Header: datapump_job.pl 10-jun-2005.10:19:20 rgiroux Exp $
#
# datapump_job.pl
# 
# Copyright (c) 2003, 2005, Oracle. All rights reserved.  
#
#    NAME
#      datapump_job.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rgiroux     06/10/05 - 
#    rgiroux     06/03/05 - add error messages 
#    rgiroux     05/23/05 - fix for bug 4369796; fail jobs on null handle 
#    rgiroux     05/23/05 - update with MAINSA version
#    rgiroux     05/04/05 - fix for bug 4345325; don't allow nonprived users 
#                           to turn on tracing 
#    rgiroux     07/15/04 - fix for bug 3640595; fail job on data pump error 
#    ngade       04/01/04 - tts support and cleanup
#    rgiroux     02/13/04 - fix for bug 3422396; use new get_status procedure 
#    rgiroux     11/21/03 - change job_state_nr back to job_state 
#    rgiroux     11/21/03 - fix for bug 3271191; allow restart of job while 
#                           it's being monitored 
#    rgiroux     11/14/03 - enhance debugging 
#    rgiroux     11/13/03 - fixes for bugs 3077896 and 3247523; get more 
#                           information on job failure and enable tracing if 
#    rgiroux     10/23/03 - fix for bug 3176547; detect bad data pump jobs 
#    npamnani    10/02/03 - loop on condition 
#    ngade       02/21/03 - implement server changes
#    ngade       02/06/03 - flush stdout, cleanup
#    ngade       01/31/03 - handle errors, mode
#    ngade       01/17/03 - ngade_more_dp_changes
#    ngade       01/17/03 - Creation
# 

require "$ENV{EMDROOT}/sysman/admin/scripts/emd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/dataUtilities/datapump_util.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/db_common.pl";

use strict;
use DBI qw(:sql_types);

## global variables.
use vars qw($job_state $is_prived);

## Datapump Job constants
use constant  JOB_NOT_RUNNING   => 'NOT RUNNING';
use constant  JOB_IDLING        => 'IDLING';
use constant  JOB_DEFINING      => 'DEFINING';
use constant  JOB_EXECUTING     => 'EXECUTING';


## GET_STATUS SQL
my $sql_get_status = q{
declare  
  get_status_wip_error_message CONSTANT NUMBER := 13;
  get_status_timeout CONSTANT NUMBER := -1;
  ind           number;
  status        ku$_status;
  job_state     varchar2(30);
  le_wip        ku$_LogEntry;
  le_error      ku$_LogEntry;

  procedure display_status(msg in varchar2) is
      msg1 varchar2(255);
      len integer := length(msg);
      i integer := 1;
  begin
      dbms_output.enable(1000000);
      loop
        msg1 := substr(msg, i, 255);
        dbms_output.put_line(msg1);
        len := len - 255;
        i := i + 255;
      exit when len <= 0;
      end loop;
  end display_status;
    
  begin
    dbms_datapump.get_status(:handle, get_status_wip_error_message, get_status_timeout, job_state, status);
    :job_state := status.job_status.state;

    le_wip := status.wip;
    if le_wip is not null then
      ind := le_wip.FIRST;
      while ind is not null loop
        display_status(le_wip(ind).LogText);
        ind := le_wip.NEXT(ind);
      end loop;
    end if;

    le_error := status.error;
    if le_error is not null then
      ind := le_error.FIRST;
      :error_status := 'true';
      while ind is not null loop
        display_status(le_error(ind).LogText);
        ind := le_error.NEXT(ind);
      end loop;
    end if;
  end;
};

###################################
## MAIN METHOD TO START A DATAPUMP JOB
###################################
sub start_datapump_job
{
  ##
  # 1. connect db.
  # 2. attach job
  # 3. start job
  # 4. read job status
  # 5. disconnect db.
  ##
  my($user, $password, $role, $job_name) = @_;  
  my $dbh = connect_database($user, $password, $role);  
  my ($handle) = attach_job($dbh, $job_name, $user);
  if(defined $handle)
  {
    print_debug("Data Pump: handle: $handle \n");  
    start_job($dbh, $job_name, $handle);
    get_job_info($dbh, $job_name, $handle);
    disconnect_database($dbh);
  }
  else
  {
    print_error("Data Pump: attach_job failed\n");
    exit(1);
  }
}

#####################################
##   ATTACH JOB   
#####################################
sub attach_job()
{
  my ($dbh, $job_name, $user) = @_;
  
  ## ATTACH JOB SQL
  my $sql_attach_job = q{
    declare
      sqlcmd        varchar2(200);
      sqlcmd_validate        varchar2(200);
      sqlcmd_validate_state        varchar2(200);
      tmp_count     number;
      done          boolean;
      valid_job     boolean;
      h1            integer;
      trace         number;

      begin
       dbms_output.enable(1000000);
       tmp_count := 0;
       done := false;
       valid_job := true;
       trace := :set_trace;
           sqlcmd_validate := :sqlcmd_validate;
           execute immediate sqlcmd_validate into tmp_count;

           dbms_output.put_line('');
           if tmp_count <= 0 then
                dbms_output.put_line('ERROR: No data pump job named "' || :job_name || '" exists in the database.');
                valid_job := false;
                done := true;
           end if;

           tmp_count := 0;
           if valid_job then
               sqlcmd_validate_state := :sqlcmd_validate_state;
               execute immediate sqlcmd_validate_state into tmp_count;

               dbms_output.put_line('');
               if tmp_count <= 0 then
                    dbms_output.put_line('ERROR: Invalid data pump job state; one of: DEFINING or EXECUTING.');
                    dbms_output.put_line('       Wait a few moments and check the log file (if one was used) for more details.');
                    valid_job := false;
                    done := true;
               end if;
           end if;
       

           while NOT done
             loop
                begin
                  sqlcmd := :sqlcmd;
                  execute immediate sqlcmd into tmp_count;
                  if tmp_count > 0 then
                      done := true;
                  end if;
                end;
              end loop;

           if valid_job = true then
               begin
                 h1 := dbms_datapump.attach(:job_name);
                 if trace = 1 then
                   dbms_datapump.set_parameter(h1, 'TRACE', 16711936);
                 end if;
                :handle := h1;
               end;
           end if;
    end;
  };  

  
  my $dbcur = prepare_statement($dbh, $sql_attach_job, $job_name);

  ## Execute
  my $handle;

  $job_state = JOB_NOT_RUNNING;
  my $job_state_idling = JOB_IDLING;
  my $job_state_defining = JOB_DEFINING;
  my $job_state_executing = JOB_EXECUTING;
  
  my $sqlcmd = "select count(*) from dba_datapump_jobs where owner_name='$user' and job_name='$job_name' and (state='$job_state' or state='$job_state_idling')";
  my $sqlcmd_validate = "select count(*) from dba_datapump_jobs where owner_name='$user' and job_name='$job_name'";
  my $sqlcmd_validate_state = "select count(*) from dba_datapump_jobs where owner_name='$user' and job_name='$job_name' and state not in ('$job_state_defining', '$job_state_executing')";

  print_debug("Data Pump:sqlcmd $sqlcmd\n");
  print_debug("Data Pump:sqlcmd $sqlcmd_validate\n");

  $dbcur->bind_param(":job_name", $job_name);
  $dbcur->bind_param(":sqlcmd", $sqlcmd); 
  $dbcur->bind_param(":sqlcmd_validate", $sqlcmd_validate); 
  $dbcur->bind_param(":sqlcmd_validate_state", $sqlcmd_validate_state); 

  my $trace = 0;
  
  if(EMAGENT_isPerlDebugEnabled())
  {
    if(defined $is_prived)
    {
      print_debug("Setting Debug on\n");
      $trace = 1;
    }
  }
  $dbcur->bind_param(":set_trace", $trace, SQL_NUMERIC);

  $dbcur->bind_param_inout(":handle", \$handle, SQL_INTEGER);

  $dbcur->execute || get_wip_err_status_msg($dbh, $dbcur, $handle, $job_name);

  $dbcur->finish();
  my @output = $dbh->func( 'dbms_output_get' );

  my $output;
  foreach $output(@output)
  {
    print STDOUT "$output\n";
  }
  return $handle;
}  


#####################################
##   STARTING JOB
#####################################
sub start_job()
{
  print_debug("Data Pump: Starting the Job\n");
  my ($dbh, $job_name, $handle) = @_;
  
  ## START JOB SQL
  my $sql_start_job = q{
  begin
    dbms_datapump.start_job(:handle);
  end;
  };


  my $dbcur = prepare_statement($dbh, $sql_start_job, $job_name);    
  $dbcur->bind_param(":handle", $handle);
  $dbcur->execute || get_wip_err_status_msg($dbh, $dbcur, $handle, $job_name);

}

##############################################
##   JOB STARTED SUCCESSFULLY - GET JOB STATUS
##############################################
sub get_job_info()
{
  print_debug("Data Pump: Getting the Log Information\n");
  my ($dbh, $job_name, $handle, $error_status) = @_;

  my $count = 0;

  while ($job_state !~ /COMPLETED/i  && $job_state !~ /STOPPED/i)
  {
    my $dbcur = prepare_statement($dbh, $sql_get_status, $job_name);  
    $dbcur->bind_param(":handle", $handle);
    $dbcur->bind_param_inout(":job_state", \$job_state, 2);    
    $dbcur->bind_param_inout(":error_status", \$error_status, 10);    
    execute_statement($dbh, $dbcur, $job_name);  
    $count++;

    $dbcur->finish();
    my $output;
    my @output = $dbh->func( 'dbms_output_get' );
    foreach $output(@output)
    {
      print STDOUT "$output\n";
    }
  }

  print_debug("Data Pump: PL/SQL count: $count : job_state: $job_state\n");

  #######################   
  ## Fail job if the job was STOPPED.
  ## TODO: Indicate the EM Job that the datapump job was suspended/stopped.
  ## Note: Distinguish between stopped and suspended jobs:
  ##  - query the dba_datapump_job view and if it returns no rows then the job was stopped else the job was suspended.
  #######################   
  if($job_state =~ /STOPPED/i)
  {
    print_error("Data Pump: Job Stopped\n");
    exit(1);
  }

  if($error_status =~ /TRUE/i)
  {
    print STDOUT "Execution errors encountered.\n\n";
    print STDOUT "Job state: $job_state\n";
    exit(1);
  }

  print STDOUT "Job state: $job_state\n";
}

###################################################
##   GET WIP/ERROR MESSAGES FOR THE JOB ON FAILURE
###################################################
sub get_wip_err_status_msg
{
  print_debug("Data Pump: Error Occurred: Getting WIP/ERROR/STATUS Messages\n");  
  my($dbh, $dbcur, $handle, $job_name, $error_status) = @_;

  my $dbcur = prepare_statement($dbh, $sql_get_status, $job_name);
  $dbcur->bind_param(":handle", $handle);
  $dbcur->bind_param_inout(":job_state", \$job_state, 2);    
  $dbcur->bind_param_inout(":error_status", \$error_status, 10);    
  execute_statement($dbh, $dbcur, $job_name);  
  $dbcur->finish();

  my $output;
  my @output = $dbh->func( 'dbms_output_get' );
  
  foreach $output(@output)
  {
    print STDOUT "$output\n";
  }
}

##############################################
## PERL TESTING
## Submit a export job (with abort-step = -1)
## then call test(). Modify parameters.
## At command line set EMDROOT and run command
## runperl datapump.pl
##############################################
## expdptest();
sub expdptest()
{

  # Removal of sensitive data in shipping product due to secure coding 
  # practices.
  die("JOB NOT SUBMITTED - no implementation...\n");
}
1;


