#!/usr/local/bin/perl
# 
# $Header: dbAuditPerm.pl 17-jun-2005.11:47:32 dsukhwal Exp $
#
# dbAuditPerm.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      dbAuditPerm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    dsukhwal    05/04/05 - handle win32 cases 
#    dsukhwal    02/15/05 - exceptional cases in file_perm usage 
#    dkjain      12/28/04 - Removed check_permission() 
#    dkjain      12/17/04 - Remove else part which gets executed for null path 
#    dkjain      10/31/04 - Fixed unable to connect
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
# 
  require "emd_common.pl";
  require "semd_common.pl";
  require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaDbUtils.pl";
  require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaUtils.pl";

  my $dsn = "dbi:Oracle:" ;
  my %stdinArgs = get_stdinvars();
  my $username = $stdinArgs{"EM_TARGET_USERNAME"};
  my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
  my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
  my $address = $ENV{EM_TARGET_ADDRESS};
  my $role = $ENV{EM_TARGET_ROLE};
  my $mode = 0;

  if($role =~ /SYSDBA/i)
  {
    $mode = 2;
  }
  elsif($role =~ /SYSOPER/i)
  {
    $mode = 4;
  }

  my $property1 = "audit_file_dest" ;  #the properties are nt_$property for mswin32. This is effected in the subroutine 
                            #db_audit_perm by suffixing nt_
  my $property2 = "user_dump_dest" ;
  my $property3 = "background_dump_dest" ;
  my $property4 ="core_dump_dest";
  
  my $afdMax = $ENV{'AFDMAX'};
  my $uddMax = $ENV{'UDDMAX'};
  my $bddMax = $ENV{'BDDMAX'};
  my $cddMax = $ENV{'CDDMAX'};
  
  my $table = "v\$parameter";  
  my $value = "value";
  my $name = "name"; 

  my $dbh = open_db_connection("dbi:Oracle:", "$username@".$address,$password,$mode); 
  #verfied that this value will have no comma separated destinations
  #only one row per policy
  my @auditFileDest = getValue($dbh,$value,$name, "audit_file_dest",$table);
  my @userDumpDest = getValue($dbh,$value,$name, "user_dump_dest",$table);
  my @backgrdDumpDest = getValue($dbh,$value,$name, "background_dump_dest",$table);
  my @coreDumpDest = getValue($dbh,$value,$name, "core_dump_dest",$table);
  close_db_connection($dbh);

  if($auditFileDest[0] ne ""){
    db_audit_perm($property1,$auditFileDest[0], $afdMax); 
  }

  if($userDumpDest[0] ne ""){
   db_audit_perm($property2,$userDumpDest[0], $uddMax);
  }

  if($backgrdDumpDest[0] ne ""){
   db_audit_perm($property3,$backgrdDumpDest[0], $bddMax);
  }

  if($coreDumpDest[0] ne ""){
   db_audit_perm($property4,$coreDumpDest[0], $cddMax);
  }


 sub db_audit_perm{
    my $retMode;
    my $permString ;
    my ($property,$fpath,$maxRows) = @_ ;
    $fpath =~ s/^\?/$oracleHome/g;
    if($^O eq "linux"){#platform is linux
        $retMode = file_perm($fpath);  
        if($retMode >= 0){ #file_perm returns -1 in case of failure
            $retMode = $retMode & 0777 ;
            if(($retMode & 007)){
               $fpath = check_512char($fpath);   	
               printf "em_result=$property|%03o|$fpath\n", $retMode ;
            }
        }
    }
    elsif($^O eq "MSWin32"){
        my $perm = win32_file_perm($fpath);
        if($perm != -1){
            print "em_result=nt_$property|$perm|$fpath\n";
        }
    }
 }

 
