#!/usr/local/bin/perl
# 
# $Header: dbControlFilesPerm.pl 16-jun-2005.16:15:45 dsukhwal Exp $
#
# dbControlFilesPerm.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      dbControlFilesPerm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    dsukhwal    05/20/05 - Adding support to limit the num of rwos to b 
#                           uploaded 
#    dkjain      12/26/04 - Comma separated string splits up 
#    dkjain      10/31/04 - Fixed unable to connect
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
# 
  require "emd_common.pl";
  require "semd_common.pl";
  require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaDbUtils.pl";
  require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaUtils.pl";
  my %stdinArgs = get_stdinvars();
  my $username = $stdinArgs{"EM_TARGET_USERNAME"};
  my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
  my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
  my $address = $ENV{EM_TARGET_ADDRESS};
  my $role = $ENV{EM_TARGET_ROLE};
  my $mode = 0;
  my $maxCount = $ENV{CMAXCOUNT} ;
  my $rowNum = 0;

  if($role =~ /SYSDBA/i)
  {
    $mode = 2;
  }
  elsif($role =~ /SYSOPER/i)
  {
    $mode = 4;
  }

 
 my $property = "db_control_files_perm" ;#the property  is nt_$property for mswin32.
 my $table = "v\$parameter";  
 my $value = "value";
 my $name = "name" ;
 my $dsn = "dbi:Oracle:";
 my $limit = 0;

 my $dbh = open_db_connection("dbi:Oracle:", "$username@".$address,$password,$mode); 
 my @controlFiles = getValue($dbh,$value,$name, "control_files",$table);
 close_db_connection($dbh);
 my $mask = 006 ;
 $globalProperty = $property ;  
 if($controlFiles[0] ne ""){
    if($^O eq "linux"){#platform is linux
        comma_separated_files($controlFiles[0],$mask,$maxCount);
    }
    elsif($^O eq "MSWin32"){
        win32_comma_sep_files_perm($controlFiles[0], $maxCount, "nt_$property");
    }
 }

