#  $Header: dbdumpfull.pl 05-aug-2003.10:23:35 jsoule Exp $
#
#
# Copyright (c) 2001, 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      dbdumpfull.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      It connects to a database, gets background_dump_dest and user_dump_dest,
#      then checks the disk usage for each destination.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#      jsoule    08/05/03 - 
#      jsoule    08/04/03 - do not trigger alert for unsupported platforms 
#      ychan     09/18/02 - ychan_move_dbscript
#      xxu       06/24/02 - remove /usr/local/bin/perl
#      prabuck   02/21/02 - removed SQL logic...caller must provide info
#      aaitghez  08/05/01 - adding dbms_registration call.
#      qsong     07/24/01 -
#      aaitghez  06/28/01 - removing seting oracle home.
#      aaitghez  06/22/01 - naming convention.
#      aaitghez  06/22/01 - set oracle_home at start of script.
#      aaitghez  06/21/01 - adding required header.
#      xxu       05/21/01 - cut over from tcl
#      xxu       05/21/01 - Creation
#

# use/require appropriate libraries

use strict;
use Oraperl;

require "emd_common.pl";
require "semd_common.pl";

# create static array representing the three destination types

my @type = ("background", "core", "user");

# get $ORACLE_HOME from environment

my $oracle_home = $ENV{EM_TARGET_ORACLE_HOME};
my $count = 0;
my $destType;

# iterate through @type...command line args must line up with @type order

foreach $destType (@type)
{
    my $destDir = shift(@ARGV);

    # resolve ? to $ORACLE_HOME to qualify destination relative to $ORACLE_HOME

    $destDir =~ s/^\?/$oracle_home/g;

    # obtain disk usage for each of 3 destination directories and print results/errors

    my @diskusage = get_disk_usage($destDir);
    if ( $diskusage[0] == -1 ) {
        EMAGENT_PERL_WARN("Couldn't get disk usage for disk $destDir");
        print "em_result=$destType|$destDir|||\n";
    } else {
        print "em_result=$destType|$destDir|$diskusage[0]|$diskusage[1]|$diskusage[3]\n";
    }
}

exit 0;

