#  $Header: dgGetPrimary.pl 03-dec-2004.07:30:08 kramarat Exp $
#
# Copyright (c) 2002, 2004, Oracle. All rights reserved.  
#
#    NAME
#      dgGetPrimary.pl
#
#    DESCRIPTION
#      This metric test determines the prmiary database name for a standby database in a Data Guard configuration.
#
#    OUTPUT:
#	For 9i:
#	Not Supported
#
#	For 10g:
#	Primary DB Name
#
#    NOTES
#      DBI handles automatic error checking.
#
#    MODIFIED   (MM/DD/YY)
#      kramarat   12/03/04 - kramarat_new-topology
#      kramarat   11/03/04 - Creation
#

use strict;
use DBI;
use DBI qw(:sql_types);

require "$ENV{EMDROOT}/sysman/admin/scripts/emd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/dg/dgutil.pl";

# RaiseError
$SIG{__DIE__} = \&handleError;
# PrintError
$SIG{__WARN__} = \&handleWarning;

# Trace the target name.
EMD_PERL_DEBUG("Database target=$ENV{EM_TARGET_NAME}");

# It should work for only 10g.
my $db_version = $ENV{VersionCategory};
if (!($db_version =~ /^10g/i))
{
  EMD_PERL_INFO("In order to compute DGPrimaryDBName metric, the database version must be 10gR1 or higher.");
  exit 0;
}


# Connect to the instance.
my %stdinArgs = get_stdinvars();
my $username = $stdinArgs{EM_TARGET_USERNAME};
my $password = $stdinArgs{EM_TARGET_PASSWORD};
my $role = $ENV{EM_TARGET_ROLE};
my $mode = 0;
if($role =~ /SYSDBA/i)
{
  $mode = 2;
}
elsif($role =~ /SYSOPER/i)
{
  $mode = 4;
}

my $address = $ENV{EM_TARGET_ADDRESS};
my $lda = DBI->connect('dbi:Oracle:', "$username@".$address, "$password", {ora_session_mode => $mode, PrintError => 0, RaiseError => 1});

# Make a few more checks before continuing.
my $broker = verifyCommon($lda);

# evaluate metric for broker
if ($broker =~ /TRUE/i)
{
  doEval($lda, $db_version);
}

$lda->disconnect;

exit 0;

# Verify dg_broker_start, primary db and config enabled.
# Parameters
# lda - The login identifier (Login Data Area).
sub verifyCommon
{
  my ($lda) = @_;

  # Initialization parameter 'dg_broker_start' must be TRUE.
  verify_broker($lda);

  my $broker = verify_broker($lda);

  # The configuration must be enabled (if using the broker)
  if ($broker =~ /TRUE/i)
  {
    verify_config_enabled($lda);
  }
  return $broker;
}


# Handle 10gR1 10gR2 support.
# Parameters
# lda - The login identifier (Login Data Area).
# db_version - The database version 9iR2 or 10g.
sub doEval
{
  my ($lda, $db_version) = @_;

  # Retrieve the configuration object content.
  my $indoc = "<DO_CONFIGURE_DRC><GET_DRC/></DO_CONFIGURE_DRC>";
  my $drc_obj = get_dg_document($lda, $indoc);

  # Retrieve the list of sites.
  my (@site_list);
  my ($site_id, $site_obj);
  my $drc_start_pos = -1;
  my $i = 0;
  while (($site_id = get_dg_token($drc_obj, "site_id", $drc_start_pos)) ne "")
  {
    EMD_PERL_DEBUG("site_id=$site_id");
    # Retrieve the site object content.
    $indoc = "<DO_CONFIGURE_SITE><GET_SITE site_id=\"$site_id\"/></DO_CONFIGURE_SITE>";
    $site_obj = get_dg_document($lda, $indoc);
    $site_list[$i] = $site_obj;
    $i++;
  }

  # Process the primary site first.
  my $default_state;
  my $site_start_pos;
  my $potential_data_loss;
  my $current_log = 0;
  EMD_PERL_DEBUG("Process the primary...");
  foreach $site_obj (@site_list)
  {
    # Parse out the default state (to determine if PRIMARY or STANDBY).
    $site_start_pos = -1;
    $default_state = get_dg_token($site_obj, "default_state", $site_start_pos);
    if ($default_state eq "PRIMARY")
    {
      processSiteObject($lda, $db_version, $site_obj, $default_state, $potential_data_loss, $current_log);
      last; # break out of the for loop
    }
    else
    {
      next;
    }
  } # foreach site

}

# Process a site object.
# Parameters
# lda - The login identifier (Login Data Area).
# db_version - The database version 9iR2 or 10g.
# site_obj - The site content object.
# default_state - The default state of the site object.
# potential_data_loss (10g) - IN/OUT- The PotentialDataLoss property value.
# current_log (9i) - IN/OUT - The primary current log.
# Return result list.
sub processSiteObject
{
  my ($lda, $db_version, $site_obj, $default_state, $potential_data_loss, $current_log) = @_;
  my $site_start_pos = -1;

  my $site_name;
  $site_name = get_dg_token($site_obj, "name", $site_start_pos);
  EMD_PERL_DEBUG("site_name=$site_name");


  # Send the results back.
  my $result;
  if ($db_version =~ /^10g/i)
  {

    $result = "em_result=$site_name\n";
  }
  print $result;
  EMD_PERL_DEBUG("$result");

}

