#  $Header: dgPerf.pl 01-sep-2005.10:50:15 gallison Exp $
#
# Copyright (c) 2002, 2005, Oracle. All rights reserved.  
#
#    NAME
#      dgPerf.pl
#
#    DESCRIPTION
#      This metric test determines performance metric information for a Data Guard configuration. .
#
#    OUTPUT:
#	For 10.2:
#	DB Object Name, Failover Time (secs), LAG Time (secs), Apply Rate (KB/sec)
#	Potential Data Loss (secs), Status 
#
#    NOTES
#      DBI handles automatic error checking.
#
#    MODIFIED   (MM/DD/YY)
#      gallison  09/01/05 - Fix lag calculations 
#      gallison  03/23/05 - Update with new names 
#      gallison  02/25/05 - Rename metrics
#      gallison  01/05/05 - Fix table name 
#      gallison  11/03/04 - gallison_dg_perf2
#      gallison  09/22/04 - 10.2 support 
#

use strict;
use DBI;
use DBI qw(:sql_types);

require "$ENV{EMDROOT}/sysman/admin/scripts/emd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/dg/dgutil.pl";

# RaiseError
$SIG{__DIE__} = \&handleError;
# PrintError
$SIG{__WARN__} = \&handleWarning;

# Trace the target name.
EMD_PERL_DEBUG("Database target=$ENV{EM_TARGET_NAME}, role=$ENV{EM_TARGET_ROLE}");

# Data Guard supports 9iR2 and 10g.
my $db_version = $ENV{VersionCategory};
verify_dbversion($db_version);

# Connect to the instance.
my %stdinArgs = get_stdinvars();
my $username = $stdinArgs{EM_TARGET_USERNAME};
my $password = $stdinArgs{EM_TARGET_PASSWORD};
my $role = $ENV{EM_TARGET_ROLE};
my $mode = 0;
if($role =~ /SYSDBA/i)
{
  $mode = 2;
}
# Can only monitor standby databases with SYSDBA connection.
else
{
  EMD_PERL_ERROR("Standby Databases must be monitored with SYSDBA credentials.");
  die "Standby Databases must be monitored with SYSDBA credentials.\n";
}

my $address = $ENV{EM_TARGET_ADDRESS};
my $lda = DBI->connect('dbi:Oracle:', "$username@".$address, "$password", {ora_session_mode => $mode, PrintError => 0, RaiseError => 1});

# Register this test once we're connected.
register_metric_call($lda);

my $database_role = getDBRole($lda);

# Make a few more checks before continuing.
getMetrics($lda,$database_role); 

$lda->disconnect;

exit 0;

# getDBRole - returns database role
# Parameters
# lda - The login identifier (Login Data Area).
sub getDBRole
{
  my ($lda) = @_;
  
  # Ensure that the 'DATABASE_ROLE' is PRIMARY.
  my $sql = "select DATABASE_ROLE from v\$database";
  my $dbcur = $lda->prepare($sql);
  $dbcur->execute;
  my @row = $dbcur->fetchrow_array();
  my $database_role = $row[0];
  return $database_role;
}

sub getMetrics
{
  # todo - combine both into new getStatusNoBroker routine...
  my ($lda, $db_version) = @_;
  
  EMD_PERL_DEBUG("Getting perf metrics for a $database_role");
  my $sql = "SELECT SUM(DECODE(name, 'apply finish time', value, 0)) FOT,  SUM(DECODE(name, 'apply lag', value, 0)) LAG, SUM(DECODE(name, 'transport lag', value, 0)) PDL  from (SELECT name, extract(day from p.val) *86400 + extract(hour from p.val) *3600 + extract(minute from p.val) *60 + extract(second from p.val) value from (SELECT name,to_dsinterval(value) val from v\$dataguard_stats) p )";
  my $dbcur = $lda->prepare($sql);
  $dbcur->execute;
  my @row = $dbcur->fetchrow_array();
  my $fot = $row[0];
  my $lag = $row[1];
  my $pdl = $row[2]; 

  $sql = "SELECT * from (select SUM(DECODE(name, 'estimated startup time', value, 0)) from v\$dataguard_stats),(select value from v\$dataguard_stats where name='standby has been open')";
  $dbcur = $lda->prepare($sql);
  $dbcur->execute;
  @row = $dbcur->fetchrow_array();
  my $t1 = $row[0];
  my $bounce = $row[1];

  if ($bounce eq "Y")
  {
    $fot = $fot + $t1;
  }
  
  EMD_PERL_DEBUG("Getting apply time");
  
  my $blocks;
  if ($database_role =~ /PHYSICAL STANDBY/i)
  {
    $sql = "SELECT s.value*512/1000 KB_bytes from v\$sysstat s where s.name='redo blocks read for recovery'";
  }
  else
  {
    $sql = "SELECT t.value/1000 from v\$logmnr_stats t where t.name='bytes of redo processed'";  
#    $sql = "SELECT s.value*512/1000 KB_bytes from v\$sysstat s where s.name='redo blocks written'";
  }
  EMD_PERL_DEBUG("Getting blocks");
  $dbcur = $lda->prepare($sql);
  $dbcur->execute;
  @row = $dbcur->fetchrow_array();
  $blocks = $row[0];
  
  my $result;
  $result = "em_result=$fot|$lag|$pdl|$blocks\n";
  print $result;
  EMD_PERL_DEBUG("$result");
  $lda->disconnect;
}

