#!/usr/local/bin/perl
# 
# $Header: getphysicalcpu.pl 25-aug-2005.14:56:16 blivshit Exp $
#
# getphysicalcpu.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      getphysicalcpu.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    blivshit    08/25/05 - don't call the non-public ecm interface, call 
#                           agent's interface instead 
#    zsyed       04/12/05 - zsyed_dbcontrol_main_1
#    zsyed       03/30/05 - Creation
# 

require "emd_common.pl";
require "semd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/db_common.pl";

use vars qw($NT);
use hostGenFunctions;

$perlbin = trim($ARGV[0]);
$scriptsdir = trim($ARGV[1]);

if($NT)
{
  my $orahome = $ENV{ORACLE_HOME};
  my $emdroot = $ENV{EMDROOT};

  if($emdroot eq "")
  {
    $emdroot = $orahome;
  }

  @cputext = `$emdroot/bin/nmeo.exe HARDWARE`;

  foreach $line (@cputext)
  {
    if($line =~ /NUMBER_OF_CPUS/)
    {
      @cpulinevalues1 = split(/>/, $line);
      @cpulinevalues2 = split(/</, $cpulinevalues1[1]);
      $cpunum = $cpulinevalues2[0];

      print "em_result=";
      print $cpunum;
      exit;
    }
  }
}
else
{
    # agent code doesn't work!
    # $cpunum = getCpuCount();

  my @processorLines = `grep '^processor[	]*:' /proc/cpuinfo`;
  if ($? != 0)
  {
      EMAGENT_PERL_DEBUG("grep of /proc/cpuinfo failed.");
      $cpunum=0;
  }
  else 
  {
      $cpunum = 0;
      foreach $line (@processorLines)
      {
          $cpunum++;
      }

      if ( $cpunum < 1 )
      {
          $cpunum = 1;
      }
  }
  
  print "em_result=";
  print $cpunum;
  exit;
}


sub trim {
 my $string = shift(@_);
 $string =~ s/\s//g;
 return $string;
}
