#!/usr/local/bin/perl
# 
# $Header: configMetricCollector.pl 13-oct-2005.18:04:33 jsutton Exp $
#
# configMetricCollector.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      configMetricCollector.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsutton     10/13/05 - Remove hard liveLink refs 
#    ndutko      08/03/05 - ndutko_code_checkin
#    dkapoor     04/04/05 - Creation
# 
require "$ENV{EMDROOT}/sysman/admin/scripts/emd_common.pl";

my $oracle_home = $ENV{EM_TARGET_ORACLE_HOME};
my $db_name = $ENV{DBName};
EMD_PERL_INFO("In configMetricCollector for oh=[$oracle_home] and db_name=[$db_name]");
my $metric = $ENV{Metric};
my $configFile = "$oracle_home/ccr/data/$db_name.ll";
EMD_PERL_INFO("In configMetricCollector for [$configFile] and [$metric]");

if (!defined $configFile )
{
    EMD_PERL_INFO("em_error=The livelink configuration file not passed.");
    print STDERR "em_error=The livelink configuration file not passed.\n";
    exit (-1);
}
if( !(-f $configFile))
{
    print STDERR "em_error=The livelink configuration file \"$configFile\" not found.\n";
    exit (-1);
}
my $columnCount = $ENV{MetricColumnCount};

my $found = 0;
if(open(CONFIG_FILE_READER, $configFile))
{
    my $line;
    while($line = <CONFIG_FILE_READER>)
    {
        chomp($line);
        if ($line =~ /^$metric:End/)
        {
            last; # found the metric end, exit the loop
        }
        elsif ($line =~ /^$metric:Begin/)
        {
            #found the metric start, read the data from the next line
            $found = 1;
            next;
        }
        elsif($found)
        {
            # skip lines with oddball/nonprintables?
            if ($line =~ /[^\x09\x20-\x7E]/)
            {
                next;
            }
            print "em_result=$line\n";
            EMD_PERL_INFO("Ignoring Result containing non printables :em_result=$line");
        }
    }
}
else
{
    EMD_PERL_INFO("Could not open the config file");
    print STDERR "em_error=Could not open the configuration file=\"$configFile\":$!\n";
    exit (-1);
}
