# $Header: emll/sysman/admin/scripts/db/net/oracle_listener_assoc.pl /main/6 2012/10/03 15:57:41 fmorshed Exp $
#
# Package : oracle_listener_assoc.pl
#
# Copyright (c) 2005, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       oracle_listener_assoc.pl
#
#   DESCRIPTION
#       Returns targets associated with this oracle_listener_assoc instance
#
#   List of standard assocation types are in
#   ecmAssoc.pm
#
#   returns potentially multiple 
# em_result=association_type|target_name|target_type|target_properties
#
#
# association_type: one of the types listed in ecmAssoc.pm
# target_name: the target_name of the associated target
# target_type: the target_type of the associated target
# target_properties: related information that may help determine true target name given the target_type
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      fmorshed   10/02/12 - Remove / as first character to query targets.xml
#      fmorshed   01/19/12 - In advent of central collector, change query of
#                 targets.xml to account for the new hierarchy of tags.
#      aghanti    07/07/09 - Bug 6215543 - Change listener association with db
#                            to RELATES_TO
#      pparida    10/17/07 - XbranchMerge pparida_bug-6492554 from
#                            st_emll_10.2.7
#      pparida    10/15/07 - Fix bug 6492554: Use CCR_CONFIG_HOME for OCM log,
#                            state and config dirs.
#      dkapoor    09/30/05 - refresh from dkapoor filesystem 
#      ndutko     08/03/05 - ndutko_code_checkin
#      dkapoor    05/25/05 - Created from oracle_listener_assoc.pl
##*************************************************************

######################################
# Standard Modules
######################################

use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/semd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/net/listenerUtil.pl";

######################################
# Package Specific Modules
######################################

#
# relationship types are defined in ecmassoc.pm
#
use ias::simpleXPath;
use ecmAssoc;

######################################
# Object Keys
######################################

my $assoc_depends_on = $ecmAssoc::DEPENDS_ON;
my $assoc_relates_to = $ecmAssoc::RELATES_TO;


$ENV{ORACLE_HOME} = $ENV{LSNR_ORACLE_HOME};

set_lib_path ($ENV{LSNR_ORACLE_HOME});
$ENV{TNS_ADMIN} = $ENV{LSNR_ORA_DIR};

my $machine = $ENV{LSNR_MACHINE};
my $port = $ENV{LSNR_PORT};
my $name = $ENV{LSNR_NAME};

my $listenerFile = $ENV{LSNR_ORA_DIR} . "/listener.ora";
my $executable= $ENV{LSNR_ORACLE_HOME}."/bin/lsnrctl";
my $address="(ADDRESS=(PROTOCOL=TCP)(HOST=$machine)(PORT=$port))";
my @commands = ();
push(@commands,"set displaymode raw");
push(@commands,"services $address");
push(@commands,"exit");

my $hostName = $machine;

my $discoveredTargetsFile = $ENV{CCR_CONFIG_HOME} . "/config/default/targets.xml";

# read thru discovered targets file and pull out associated rac instance targets

if (-e $discoveredTargetsFile)
{

      my $ohQueryPrefix = 'TargetHomes/TargetHome[@LOCATION="' . $ENV{ORACLE_HOME} . '"]';
      my @hostTargets = simpleXPathQuery($discoveredTargetsFile, $ohQueryPrefix . '/Targets/Target[@TYPE="host"]'); 
      for my $hostTarget (@hostTargets)
      {
             	EMD_PERL_DEBUG("HostName=".$$hostTarget{'NAME'});
		$hostName = $$hostTarget{'NAME'};
		last;
      }
}

my $result ;

eval
{
 $result = getResult($executable,\@commands,$listenerFile,$name);
};
if($@)
{
    print STDERR "em_error=Failed to run lsnrctl\n";
    exit (-1);
}

my @discoveredSids = ();
my $dbDetails = getDBDetailsDiscovery($result,$port,$hostName,@discoveredSids);
my $sid ;
EMD_PERL_DEBUG("dynamically discovered sids for address \"$address\"");
foreach $sid (keys %$dbDetails)
{
        EMD_PERL_DEBUG("dynamic sid =\"$sid\"");
        
	my $assocTargetType;
	if ($sid  =~ /^\+/ )
        {
	 $assocTargetType = $ecmAssoc::ASM_INSTANCE_TYPE;
        }
	else
	{
	 $assocTargetType = $ecmAssoc::ORACLE_DATABASE_TYPE;
	}
        print "em_result=$assoc_relates_to||$assocTargetType|$hostName:$port:$sid\n";
}
