#!/usr/local/bin/perl
# 
# $Header: ohFilesPerm.pl 13-may-2005.16:29:48 dsukhwal Exp $
#
# ohFilesPerm.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      ohFilesPerm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    dsukhwal    05/12/05 - limit number of rows pushed 
#    dkjain      03/28/05 - Limiting number of rows to be uploaded to 200
#    dsukhwal    02/15/05 - exceptional cases in file_perm usage 
#    dkjain      12/30/04 - check_permission is removed 
#    dkjain      10/31/04 - Bug-3977629
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
# 
 #As this is it to be collected for unix env only.
  use strict ;
  if(!($^O =~ "linux"))
  {
      exit(0);
  }

  # get $ORACLE_HOME from environment
  require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaDbUtils.pl";
  require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaUtils.pl";
  my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
  my $maxRows = $ENV{'OHPERM'};
  my $property = "oh_files_perm" ;
  my $limit = 0 ;
 
##find command will invoke the verify_files_perm on each file under the given point
#Which is ORACLE_HOME for this policy
   find(\&verify_files_perm,$oracleHome);

##############################################################################################

  #This is to verify owner of a given pathname recursively.
  sub verify_files_perm{
    my $fpath=$File::Find::name;
    my $permString ;
    my $flag = 0 ; 
    if(!($fpath=~ qq($oracleHome/bin) ))
    {   
     my $retMode  =  file_perm($fpath);
     if($retMode >= 0){
       $retMode = $retMode & 0777 ;
       if(($retMode & 007)){ 
          $fpath = check_512char($fpath);
          #$permString = rwx_string($retMode);
          printf "em_result=$property|%03o|$fpath\n",$retMode;
          $limit++ ;   #limiting the uploaded rows to 200
          if(  ($limit > $maxRows-1)  &&  ($maxRows != -1)  ){
	     exit(0);
	  }
       }
     }
   } 
}

