#!/usr/local/bin/perl
# 
# $Header: powerPrivileges.pl 30-jan-2005.23:48:36 dsukhwal Exp $
#
# powerPrivileges.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      powerPrivileges.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    dsukhwal    01/30/05 - 
#    dkjain      10/31/04 - Fixed unable to connect
#    dkjain      10/13/04 - dkjain_esa_impl2
#    dkjain      10/13/04 - Creation
# 
  require "emd_common.pl";
  require "semd_common.pl";
  require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaDbUtils.pl";
  require "$ENV{EMDROOT}/sysman/admin/scripts/db/esaUtils.pl";
  my %stdinArgs = get_stdinvars();
  my $username = $stdinArgs{"EM_TARGET_USERNAME"};
  my $password = $stdinArgs{"EM_TARGET_PASSWORD"};

  my $address = $ENV{EM_TARGET_ADDRESS};
  my $role = $ENV{EM_TARGET_ROLE};
  my $mode = 0;

  if($role =~ /SYSDBA/i)
  {
    $mode = 2;
  }
  elsif($role =~ /SYSOPER/i)
  {
    $mode = 4;
  }
  my $dbh = open_db_connection("dbi:Oracle:", "$username@".$address,$password,$mode); 
  getUserWithPrivileges1($dbh);
  close_db_connection($dbh) ;

   sub getUserWithPrivileges1{
	   my $sth0 ;
	   my $sth1 ;
	   my $index = 0 ;
	   my @user ;
	   my @list ;
	   my ($dbh,@priv) = @_;
			  
	   my %role_role;
	   my @grantee1, @grantee2, @grantee3, @grantee4, @grantee5, @grantee6;
	   my @grantee7, @grantee8, @grantee9, @grantee10;
	   my @grantee;
	   my $report_name;
	   my $index = 10;
	   
	   $sth1 = $dbh->prepare_cached("select grantee, privilege from dba_sys_privs where privilege in ('ALTER SESSION', 'ALTER SYSTEM', 'CREATE PROCEDURE', 'CREATE LIBRARY', 'BECOME USER', 'EXEMPT ACCESS POLICY', 'AUDIT SYSTEM', 'GRANT ANY PRIVILEGE', 'CONNECT', 'RESOURCE') union all select grantee, privilege from dba_tab_privs where privilege in ('ALTER SESSION', 'ALTER SYSTEM', 'CREATE PROCEDURE', 'CREATE LIBRARY', 'EXEMPT ACCESS POLICY', 'AUDIT SYSTEM', 'GRANT ANY PRIVILEGE', 'CONNECT', 'RESOURCE') union all select grantee, granted_role from dba_role_privs") or die "Couldn't prepare statement: " . $dbh->errstr;
				 
	   $sth1->execute() or die "Couldn't execute statement: " . $sth1->errstr;
			
	   while (@list = $sth1->fetchrow_array()) { 
		 if ($list[1] eq "ALTER SESSION") {
		   push(@grantee1, $list[0]);
		 }
		 elsif ($list[1] eq "ALTER SYSTEM") {
		   push(@grantee2, $list[0]);
		 }
		 elsif ($list[1] eq "CREATE PROCEDURE") {
		   push(@grantee3, $list[0]);
		 }
		 elsif ($list[1] eq "CREATE LIBRARY") {
		   push(@grantee4, $list[0]);
		 }
		 elsif ($list[1] eq "BECOME USER") {
		   push(@grantee5, $list[0]);
		 }
		 elsif ($list[1] eq "EXEMPT ACCESS POLICY") {
		   push(@grantee6, $list[0]);
		 }
		 elsif ($list[1] eq "AUDIT SYSTEM") {
		   push(@grantee7, $list[0]);
		 }
		 elsif ($list[1] eq "GRANT ANY PRIVILEGE") {
		   push(@grantee8, $list[0]);
		 }
		 elsif ($list[1] eq "CONNECT") {
		   push(@grantee9, $list[0]);
		 }
		 elsif ($list[1] eq "RESOURCE") {
		   push(@grantee10, $list[0]);
		 }
		 else {
			 if (exists $role_role{$list[1]}) {
				 my $temp = $role_role{$list[1]};
				 $role_role{$list[1]} = $temp."@".$list[0];
			 }
			 else {
				$role_role{$list[1]} = $list[0];
			 }
		 }
	   }
			  
	   my $count = 0;
	   my $priv_name;
	   
	  for (my $k = 0; $k < $index ; $k++) 
	  {
		   $count = 0;
		   my %roles;

		   if ($k == 0) {
			   @grantee = @grantee1;
			   $priv_name = 'ALTER SESSION';
			   $report_name = 'POWER_PRIVILEGE';
		   }
		   elsif ($k == 1) {
			   @grantee = @grantee2;
			   $priv_name = 'ALTER SYSTEM';
			   $report_name = 'POWER_PRIVILEGE';
		   }
		   elsif ($k == 2) {
			   @grantee = @grantee3;
			   $priv_name = 'CREATE PROCEDURE';
			   $report_name = 'POWER_PRIVILEGE';
		   }
		   elsif ($k == 3) {
			   @grantee = @grantee4;
			   $priv_name = 'CREATE LIBRARY';
			   $report_name = 'POWER_PRIVILEGE';
		   }
		   elsif ($k == 4) {
			   @grantee = @grantee5;
			   $priv_name = 'BECOME USER';
			   $report_name = 'BECOME_USER';
		   }   
	       elsif ($k == 5) {
			   @grantee = @grantee6;
			   $priv_name = 'EXEMPT ACCESS POLICY';
			   $report_name = 'EXEMPT_ACCESS_POLICY';
		   }
		   elsif ($k == 6) {
			   @grantee = @grantee7;
			   $priv_name = 'AUDIT SYSTEM';
			   $report_name = 'AUDIT_SYSTEM';
		   }
		   elsif ($k == 7) {
			   @grantee = @grantee8;
			   $priv_name = 'GRANT ANY PRIVILEGE';
			   $report_name = 'ALL_PRIVILEGES';
		   }
		   elsif ($k == 8) {
			   @grantee = @grantee9;
			   $priv_name = 'CONNECT';
			   $report_name = 'CONNECT_PRIVILEGE';
		   }
		   else {
			   @grantee = @grantee10;
			   $priv_name = 'RESOURCE';
			   $report_name = 'CONNECT_PRIVILEGE';
		   }


			foreach my $a (@grantee) {
				$roles{$a} = '1';
			}

			while ($count < @grantee)
			{
				if ($count == 0) {
					$roles{$grantee[$count]} = '1';
				}
				print "em_result=$grantee[$count]|$priv_name|$report_name\n";
				if (exists $role_role{$grantee[$count]})
				{
					my @temp = split(/@/,  $role_role{$grantee[$count]});
					foreach  my $i (@temp) {
						if (not exists $roles{$i}) {
						   push(@grantee, $i);
						   $roles{$i} = '1';
						}
						#$index1++;
						#$grantee1[$index1] = $temp[$i];
					}
				}
				$count++;
			}
		 }
   }