# $Header: emll/sysman/admin/scripts/db/rac_database_assoc.pl /main/8 2012/10/03 15:57:41 fmorshed Exp $
#
# Package : rac_database_assoc.pl
#
# Copyright (c) 2005, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       rac_database_assoc.pl
#
#   DESCRIPTION
#       Returns information on targets associated with this iAS instance
#
#   List of standard assocation types are in
#   ecmAssoc.pm
#
#   returns potentially multiple 
# em_result=association_type|target_name|target_type|target_properties
#
# association_type: one of the types listed in ecmAssoc.pm
# target_name: the target_name of the associated target
# target_type: the target_type of the associated target
# target_properties: related information that may help determine true target name given the target_type
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      fmorshed   10/02/12 - Remove / as first character to query targets.xml
#      fmorshed   01/19/12 - In advent of central collector, change query of
#                 targets.xml to account for the new hierarchy of tags.
#      aghanti    03/02/10 - Change RAC to CRS association to depends_on
#      glavash    07/06/09 - remove target_name from assoc to cell targets
#      ysun       04/23/09 - add cell support
#      aghanti    04/02/09 - Create RAC to CRS association
#      pparida    10/17/07 - XbranchMerge pparida_bug-6492554 from
#                            st_emll_10.2.7
#      pparida    10/15/07 - Fix bug 6492554: Use CCR_CONFIG_HOME for OCM log,
#                            state and config dirs.
#      ndutko     08/03/05 - ndutko_code_checkin
#      dkapoor    06/22/05 - Created
##*************************************************************

use strict;
#
# relationship types are defined in ecmassoc.pm
#
use ecmAssoc;
use ias::simpleXPath;

require "$ENV{EMDROOT}/sysman/admin/scripts/semd_common.pl";


#******************************************
#     Global Variables
#*****************************************
      my $result = ();
#
# as new relationships are exposed, add them here
#
my @racdb_assoc_results;

my $targetName = $ENV{TARGET_NAME};
my $discoveredTargetsFile = $ENV{CCR_CONFIG_HOME} . "/config/default/targets.xml";

  # read thru discovered targets file and pull out associated rac instance targets

  if (-e $discoveredTargetsFile)
  {
      my $ohQueryPrefix = 'TargetHomes/TargetHome[@LOCATION="' . $ENV{ORACLE_HOME} . '"]';
      my @assocTargets = simpleXPathQuery($discoveredTargetsFile, $ohQueryPrefix.'/Targets/Target[@NAME="'.$targetName.'"]/AssocTargetInstance'); 
      for my $assocTarget (@assocTargets)
      {
          #only include database instances as containment
          if ($$assocTarget{'ASSOC_TARGET_TYPE'} eq 'oracle_database')
          {
              print ("em_result=".$ecmAssoc::CONTAINS."|". $$assocTarget{'ASSOC_TARGET_NAME'}."|".$$assocTarget{'ASSOC_TARGET_TYPE'}."|\n");
          }
          #oracle_cell targets as depends_on
          if ($$assocTarget{'ASSOC_TARGET_TYPE'} eq 'oracle_cell')
          {
              print ("em_result=".$ecmAssoc::DEPENDS_ON."||".
                 $$assocTarget{'ASSOC_TARGET_TYPE'}."|".
                 $$assocTarget{'ASSOC_TARGET_PROPERTY'}."|\n");
          }
      }

      # Go through the targets file and find out which CRS this RAC corresponds to
      # Get the cluster name from targets.xml
      my @clusterTarget = simpleXPathQuery($discoveredTargetsFile, $ohQueryPrefix.'/Targets/Target[@NAME="'.$targetName.'"]/Property[@NAME="ClusterName"]');

      # Get the cluster home for the above cluster
      my @clusterHome = simpleXPathQuery($discoveredTargetsFile, $ohQueryPrefix.'/Targets/Target[@NAME="'.$clusterTarget[0]{'VALUE'}.'"]/Property[@NAME="OracleHome"]');

      my $olsnodes_cmd = $clusterHome[0]{'VALUE'}."/bin/olsnodes";
      # Execute olsnodes to get the list of all nodes belonging to this cluster
      if (-x $olsnodes_cmd)
      {
          my @clusterNodes = `$olsnodes_cmd`;
          chomp(@clusterNodes);
          # Append semi-colon separated node list to cluster name
          my $clusterNodeList = join(';', @clusterNodes).';';

          # Place cluster_name:node1;node2;... in target properties
          print ("em_result=".$ecmAssoc::DEPENDS_ON."||cluster|".$clusterTarget[0]{'VALUE'}.":".$clusterNodeList."\n");
      }
  }

