#!/usr/local/bin/perl
# 
# $Header: sgastart.pl 08-feb-2006.22:32:51 rrawat Exp $
#
# sgastart.pl
# 
# Copyright (c) 2004, 2006, Oracle. All rights reserved.  
#
#    NAME
#      sgastart.pl - Script to start SGA collector
#
#    DESCRIPTION
#      This script is called by the Collections Manager to start the
#      SGA Collector
#
#    NOTES
#      -
#
#    MODIFIED   (MM/DD/YY)
#    rrawat      02/08/06 - Backport rrawat_rfi_bug-5007858 from 
#                           st_emdbgc_10.2.0.1.0 
#    rrawat      02/01/06 - Bug-5007858
#    hopark      06/27/05 - fix advert_dir permission 
#    hopark      06/21/05 - put nmc.status under the same advert_dir as other files.
#    jsoule      06/06/05 - do not start collector in resume on NT. 
#    jsoule      05/24/05 - use correct libserver10 
#    hopark      05/14/05 - Fix ownership and mode of the collection directory 
#    hopark      05/09/05 - grabtrans 'hopark_bug-4258298' 
#                           add enable/disable collector 
#    zsyed       04/17/05 - Changing to work in GRID_AGENT_VIEW 
#    zsyed       02/07/05 - Removing inverted commas for NT 
#    zsyed       11/22/04 - Removing references to emdw 
#    zsyed       09/28/04 - Fixing Solaris collector startup problem 
#    zsyed       08/23/04 - Creation
# 

#########################
# Declare packages to use
#########################

require "emd_common.pl";
require "semd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/db_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/sgapid.pl";
use POSIX;
use vars qw($NT);

########################
# Declare variables
########################
$debug = trim($ENV{'SGASTART_TEST'});

$collmode = trim($ARGV[0]);
$connstr = trim($ARGV[1]);
$machname = trim($ARGV[2]);
$portname = trim($ARGV[3]);
$sidname = trim($ARGV[4]);

$targetorahome = trim($ARGV[5]);
$myorahome = trim($ENV{'ORACLE_HOME'});

$emdhome = trim($ENV{'EMDROOT'});

$cmd = "";
$resume = 0;
$numArgs = $#ARGV + 1;
if ($numArgs > 7) {
   $cmd = trim($ARGV[7]) ;
   $resume = ($cmd eq "resume");
}


if($emdhome eq "")
{
  $emdhome = $myorahome;
}

$advert_dir = trim($ARGV[6]);
$advert_dir = $advert_dir."/";

$msg_dir = $emdhome."/mesg/";

###################################
# Create advert_dir under myorahome
###################################
$firstdir =  $machname."_".$sidname;
$seconddir = "sysman";
$thirddir = "log";

chdir($myorahome) || die "Cannot chdir $myorahome: $!";

if(!(-d $firstdir))
{
  mkdir($firstdir, 0750) || die "Cannot mkdir $firstdir: $!";
}

chdir($firstdir) || die "Cannot chdir $firstdir: $!";

if(!(-d $seconddir))
{
  mkdir($seconddir, 0750) || die "Cannot mkdir $seconddir: $!";
}

chdir($seconddir) || die "Cannot chdir $seconddir: $!";

if(!(-d $thirddir))
{
  mkdir($thirddir, 0750) || die "Cannot mkdir $thirddir: $!";
}
chdir($thirddir) || die "Cannot chdir $thirddir: $!";

# Check to see if nmccollector exists
# If it doesn't, create it

$advert_dir = $myorahome."/".$firstdir."/".$seconddir."/".$thirddir."/";

if($NT)
{
   $groupname = 'ORA_DBA';
} else {
    $groupname = 'dba';
    $uid = POSIX::getuid();
    $gid = getgrnam($groupname);
    chown ($uid, $gid, $advert_dir) or warn "couldn't chown $advert_dir.";
    chmod (0770, $advert_dir) or warn "couldn't chmod $advert_dir.";  

    # unlink the nmcollector if it exsists
    if(chdir($advert_dir) && (-e "nmccollector"))
    {
      unlink ("nmccollector");
    }

}  

$tracefile = $advert_dir . "sgastart.trc";

$ttfile = $advert_dir . "nmc.debug";
if (-e $ttfile){
   $debug = 1;
}

TRACE("------ sgastart ".$cmd);
TRACE("ARG0 : ".$ARGV[0]);
TRACE("ARG1 : ".$ARGV[1]);
TRACE("ARG2 : ".$ARGV[2]);
TRACE("ARG3 : ".$ARGV[3]);
TRACE("ARG4 : ".$ARGV[4]);
TRACE("ARG5 : ".$ARGV[5]);
TRACE("ARG6 : ".$ARGV[6]);
TRACE("ORACLE_HOME : ".$ENV{'ORACLE_HOME'});
TRACE("EMDROOT : ".$ENV{'EMDROOT'});
TRACE("advert_dir : $advert_dir");
TRACE("nmcollector is not enabled for 10.2.0.1 and 10.2.0.2 releases");

####################################################
# Check to see if the collector is disabled
####################################################
$statusfile = $advert_dir . "nmc.status";
TRACE("statusfile : $statusfile");
$status = "disable";
if ($resume == 0) {
    open(SFP, $statusfile);
    $status = <SFP>;
    close(SFP);
} else {
    # For 10.2.0.1 and 10.2.0.2 Release disable for resume operation 
    $status = "disable";
}

if ($status eq "stopped") {
    # The collector has been stopped by other process, but failed to kill the process.
    $rpidval = getsgapid($emdhome, $connstr);
    $result = killCollector($rpidval, $statusfile);
    $status = "disable";
}

if($status =~ m/ERROR/ || $status eq "") {
    # This is the default behavior for 10.2.0.1 and 10.2.0.2 GC Agent
    $status = "disable";
}
TRACE("status = ". $status);

if ($cmd eq "status") {
    # Check to see if the collector is running. If yes, kill it.
    
    $rpidval = getsgapid($emdhome, $connstr);
    if (!($rpidval eq "")) {
         $res = killCollector($rpidval, $statusfile);
    }
    else
    {
      # set the status to disable 
      writeStatus($statusfile, "disable");
    }

    $status = "disable";
    
    TRACE("em_result =  ". $status);
    print "em_result=";
    print $status;
    exit;
}

####################################################
# Check to see if someone is monitoring DB already
# If so, exit
####################################################
$rpidval = getsgapid($emdhome, $connstr);
if ($cmd eq "stop") {
    $res = killCollector($rpidval, $statusfile);
    if ($res == -1) {
       $result = "no nmccollector process"; 
    } elsif ($res == 0) {
         $result = "failed to kill nmccollector pid=" . $rpid; 
    } elsif ($res == 1){
         $result = "killed nmccollector pid=" . $rpid; 
    }
    TRACE("em_result=".$result);
    print "em_result=";
    print $result;
    exit;
}

if ($status eq "disable") {
   
 
    # Check to see if the collector is running. If yes, kill it.
    $rpidval = getsgapid($emdhome, $connstr);
    if (!($rpidval eq "")) {
        $res = killCollector($rpidval, $statusfile);
        if ($res == -1) {
           $result = "collector is disabled. no running nmccollector process."; 
        } elsif ($res == 0) {
          $result = "disbale failed. failed to kill Exsisting nmccollector pid=" . $rpid; 
        } elsif ($res == 1){
           $result = "collector is disabled. killed running nmccollector pid=" . $rpid; 
        }
     }
     else {
       $result = "collector is disabled.";
       writeStatus($statusfile, "disable");
     }
      

     TRACE("em_result=".$result);
     print "em_result=";
     print $result;
     exit;
}

writeStatus($statusfile, "disable");

if (!($rpidval eq "")) {
     # Collector is running. Kill it. 
     $res = killCollector($rpidval, $statusfile);
     if ($res == -1) {
        $result = "no nmccollector process"; 
     } elsif ($res == 0) {
          $result = "failed to kill nmccollector pid=" . $rpid; 
     } elsif ($res == 1){
          $result = "killed nmccollector pid=" . $rpid; 
     }
     TRACE("em_result=".$result);
     print "em_result=";
     print $result;
     exit;
}

TRACE("collector not found. Dont start it in 10.2.0.1 and 10.2.0.2 releases");


sub killCollector {
    my $rpid = $_[0];
    my $sfile = $_[1];
    $res = -1;
    if ($rpid != "") {
        $res = kill 9, $rpid;
    }
    if ($res) {
        # remove the file to indicate it is disabled
        writeStatus($sfile, "disable");
    } else {
        writeStatus($sfile, "stopped");
    }
    return $res;
}
   
sub writeStatus {
   my $sfile = $_[0];
   my $s = $_[1];
   TRACE("writing ". $s ." in statusfile $sfile");
   open(SFP, ">$sfile");
   print SFP $s;
   close(SFP);
}
   

