#!/usr/local/bin/perl
# 
# e1_config.pl
# 
# Copyright (c) 2002, 2005, Oracle. All rights reserved.  
#
#    NAME
#
#    DESCRIPTION
#      Metric Script for EnterpriseOne (Former JDEdwards) configuration data.
#
#    NOTES
#      This script relies on a xml dump file produced by the EnterpriseOne deployment server.
#      There was some perl bug with using a switch statement so if/elsif was used intstead although
#      not as efficient.
#
#    MODIFIED   (MM/DD/YY)
#    kclearwater 07/28/06 - Creation


my ($scriptsDir, $file, $table) = @ARGV;

use strict;
use ias::simpleXPath;
require "$scriptsDir/emd_common.pl";
use Config;

EMD_PERL_DEBUG("e1_config START");

#windows check.  'e1_config' is windows only
my $OSNAME = $Config{'osname'};
my $IsWin32 = ($OSNAME eq 'MSWin32');
    
if($IsWin32)
{

    # validate parameters.
    if ((@ARGV) != 3)
    {
        printf "%s\n\n", "Outputs EnterpriseOne Configuration information.";
        printf "%s\n\n", "e1_config.pl query";
        printf "%s\t%s\n", "  scriptsDir", "Specifies location of CCR scripts.";
        printf "%s\t%s\n", "  file", "Specifies file name of the EnterpriseOne dump file.";
        printf "%s\t%s\n", "  table", "Specifies repository table we are gathering data for.";

    }

    if ($scriptsDir eq '')
    {
        printf "%s\n", "em_warning=The xpath query for was not specified.";
        exit;
    }
    if ($file eq '')
    {
        printf "%s\n", "em_warning=The EnterpriseOne xml dump file was not specified.";
        exit;
    }
    if ($table eq '')
    {
        printf "%s\n", "em_warning=The repository table was not specified.";
        exit;
    }
    
    if( -f $file)
    {
        #EMD_PERL_DEBUG("e1_config E1 dump file found");
        my @topLevelComponents = simpleXPathQuery($file, "oracle_e1/config");
        for my $topLevelComponent (@topLevelComponents)
        {
            # found a release.
            my $release = $$topLevelComponent{'release'};
            
            if ($table eq "MGMT_E1_CONFIG_PATHCODES")
            {
                
                    my @pathcodes = simpleXPathQuery($file, "oracle_e1/config/pathcodes/pathcode");
                    for my $pathcode (@pathcodes)
                    {                    
                        print("em_result=".$$pathcode{'EMPATHCD'}. "|".$$pathcode{'EMDL01'}. "|".$$pathcode{'EMMKEY'}. "|".$$pathcode{'EMSERSHP'}. "|".$$pathcode{'EMSTCE'}. "|".$$pathcode{'EMMRGOPT'}. "|".$$pathcode{'EMRLS'}. "|".$$pathcode{'EMJDEDBTYP'}. "|".$$pathcode{'EMDATS'}. "|".$$pathcode{'EMUNCFLG'}.  "\n");                                                                        
                    } # end for loop - pathcodes
            }   
            elsif($table eq "MGMT_E1_CONFIG_ENVIRONMENTS")
            {
                    my @environments = simpleXPathQuery($file, "oracle_e1/config/pathcodes/pathcode/environments/environment");
                    for my $environment (@environments)
                    {
                        print("em_result=".$$environment{'LMLL'}. "|".$$environment{'LMDL01'}. "|".$$environment{'LMRLS'}. "|".$$environment{'LMPATHCD'}. "|".$$environment{'LMJITINST'}. "|".$$environment{'LMCHNG'}. "|".$$environment{'LMINST1'}. "|".$$environment{'LMENHV01'}. "|".$$environment{'LMENHV02'}. "|".$$environment{'LMENHV03'}.  "\n");
                        
                    } # end for loop - environments
                                                
            }
            elsif($table eq "MGMT_E1_CONFIG_DATASOURCES")
            {
                    my @datasources = simpleXPathQuery($file, "oracle_e1/config/datasources/datasource");
                    for my $datasource (@datasources)
                    {                    
                        print("em_result=".$$datasource{'DSSRVR'}. "|".$$datasource{'DSDATP'}. "|".$$datasource{'OMDATP'}. "|".$release. "|".$$datasource{'OMSRVR'}. "|".$$datasource{'OMLIB'}. "|".$$datasource{'OMOCMA'}. "|".$$datasource{'OMOCMB'}. "|".$$datasource{'OMOMDS'}. "|".$$datasource{'OMOMJD'}. "|".$$datasource{'OMOMTO'}. "|".$$datasource{'OMOOWN'}. "|".$$datasource{'OMDLLNAME'}. "|".$$datasource{'OMDSTP'}. "|".$$datasource{'OMDL01'}. "|".$$datasource{'OMOCM1'}. "|".$$datasource{'OMOCM2'}. "|".$$datasource{'OMOCMDSC'}. "|".$$datasource{'OMDATUSE'}. "|".$$datasource{'OMDATB2'}. "|".$$datasource{'OMDBINST'}. "|".$$datasource{'OMSVRPORT'}. "|".$$datasource{'OMJDBNET'}. "|".$$datasource{'OMUNICODE'}. "|".$$datasource{'OMLOBFLG'}. "|".$$datasource{'OMDATB'}. "|".$$datasource{'OMOCM3'}. "|".$$datasource{'OMOCMC'}. "|".$$datasource{'OMLL'}. "|".$$datasource{'OMOMUI'}. "|".$$datasource{'OMOMCC'}. "|".$$datasource{'OMDSFC30'}. "|".$$datasource{'OMDSFC10'}. "|".$$datasource{'OMENHV'}. "|".$$datasource{'OMDSFF1'}.  "\n");                   
                    }# end for loop - datasources
            }
            elsif($table eq "MGMT_E1_CONFIG_MACHINES_DEP")
            {
                    my @deploymentServers = simpleXPathQuery($file, "oracle_e1/config/machines/deployment-server");
                    for my $deploymentServer (@deploymentServers)
                    {
                        print("em_result=".$$deploymentServer{'MMMKEY'}. "|".$$deploymentServer{'MMDL01A'}. "|".$$deploymentServer{'MMRLS'}. "|".$$deploymentServer{'MMHSTTYP'}. "|".$$deploymentServer{'MMDL01B'}. "|".$$deploymentServer{'MMLOCAT'}. "|".$$deploymentServer{'MDSERSHP'}. "|".$$deploymentServer{'MMDEPSRVPRM'}.  "\n");                                
                    }# end for loop - deploymentServers
            }
            elsif($table eq "MGMT_E1_CONFIG_MACHINES_ENT")
            {
                    my @enterpriseServers = simpleXPathQuery($file, "oracle_e1/config/machines/enterprise-server");
                    for my $enterpriseServer (@enterpriseServers)
                    {
                        print("em_result=".$$enterpriseServer{'MMMKEY'}. "|".$$enterpriseServer{'MMPORTNUM'}. "|".$$enterpriseServer{'MMDL01A'}. "|".$$enterpriseServer{'MMRLS'}. "|".$$enterpriseServer{'MMHSTTYP'}. "|".$$enterpriseServer{'MMDL01B'}. "|".$$enterpriseServer{'MMLOCAT'}. "|".$$enterpriseServer{'MMLGNAME'}. "|".$$enterpriseServer{'MMDSTP'}. "|".$$enterpriseServer{'MMDL01C'}. "|".$$enterpriseServer{'MMDATP'}. "|".$$enterpriseServer{'MDSERSHP'}. "|".$$enterpriseServer{'MDDEPSRVNM'}.  "\n");                                
                    }# end for loop - enterpriseServers
            }
            elsif($table eq "MGMT_E1_CONFIG_MACHINES_DATA")
            {
                    my @dataServers = simpleXPathQuery($file, "oracle_e1/config/machines/data-server");
                    for my $dataServer (@dataServers)
                    {
                        print("em_result=".$$dataServer{'MMMKEY'}. "|".$$dataServer{'MMDL01A'}. "|".$$dataServer{'MMRLS'}. "|".$$dataServer{'MMHSTTYP'}. "|".$$dataServer{'MMDL01B'}. "|".$$dataServer{'MMLOCAT'}. "|".$$dataServer{'MMDSTP'}. "|".$$dataServer{'MMDL01C'}.  "\n");                                
                    }# end for loop - dataServers
            }
            elsif($table eq "MGMT_E1_CONFIG_MACHINES_WEB")
            {
                    my @webServers = simpleXPathQuery($file, "oracle_e1/config/machines/web-server");
                    for my $webServer (@webServers)
                    {
                        print("em_result=".$$webServer{'MMMKEY'}. "|".$$webServer{'MMPORTNUM'}. "|".$$webServer{'MMDL01A'}. "|".$$webServer{'MMRLS'}. "|".$$webServer{'MMHSTTYP'}. "|".$$webServer{'MMDL01B'}. "|".$$webServer{'MMLOCAT'}. "|".$$webServer{'MMFALPH1'}. "|".$$webServer{'MDSERSHP'}. "|".$$webServer{'MDSERSHP2'}. "|".$$webServer{'MDSERSHP3'}. "|".$$webServer{'MDSERSHP4'}. "|".$$webServer{'MDDEPSRVNM'}.  "\n");                                
                    }# end for loop - webServers
            }
            elsif($table eq "MGMT_E1_CONFIG_MACHINES_WTS")
            {
                    my @terminalServers = simpleXPathQuery($file, "oracle_e1/config/machines/terminal-server");
                    for my $terminalServer (@terminalServers)
                    {
                        print("em_result=".$$terminalServer{'MMMKEY'}. "|".$$terminalServer{'MMDL01A'}. "|".$$terminalServer{'MMRLS'}. "|".$$terminalServer{'MMHSTTYP'}. "|".$$terminalServer{'MMDL01B'}. "|".$$terminalServer{'MMLOCAT'}.  "\n");                                
                    }# end for loop - terminalServers
                    
            }
            elsif($table eq "MGMT_E1_CONFIG_MACHINES_WCRYS")
            {
                    my @crystalWebServers = simpleXPathQuery($file, "oracle_e1/config/machines/crystalWeb-server");
                    for my $crystalWebServer (@crystalWebServers)
                    {
                        print("em_result=".$$crystalWebServer{'MMMKEY'}. "|".$$crystalWebServer{'MMPORTNUM'}. "|".$$crystalWebServer{'MMDL01A'}. "|".$$crystalWebServer{'MMRLS'}. "|".$$crystalWebServer{'MMHSTTYP'}. "|".$$crystalWebServer{'MMDL01B'}. "|".$$crystalWebServer{'MMLOCAT'}.  "\n");                                
                    }# end for loop - crystalWebServers
            }
            elsif($table eq "MGMT_E1_CONFIG_MACHINES_ECRYS")
            {
                    my @crystalCMSServers = simpleXPathQuery($file, "oracle_e1/config/machines/crystalCMS-server");
                    for my $crystalCMSServer (@crystalCMSServers)
                    {
                        print("em_result=".$$crystalCMSServer{'MMMKEY'}. "|".$$crystalCMSServer{'MMDL01A'}. "|".$$crystalCMSServer{'MMRLS'}. "|".$$crystalCMSServer{'MMHSTTYP'}. "|".$$crystalCMSServer{'MMDL01B'}. "|".$$crystalCMSServer{'MMLOCAT'}. "|".$$crystalCMSServer{'MDSERSHP'}.  "\n");         
                    }# end for loop - crystalCMSServers
            }
            elsif($table eq "MGMT_E1_CONFIG_UPDATES_UPDATES")
            {
                    my @updates = simpleXPathQuery($file, "oracle_e1/config/updates/update");
                    for my $update (@updates)
                    {
                        print("em_result=".$$update{'SUPKGNAME'}. "|".$$update{'SURLS'}. "|".$$update{'SUFRLS'}. "|".$$update{'SUTRLS'}. "|".$$update{'SUDL01A'}. "|".$$update{'SUSUTYPE'}. "|".$$update{'SUDL01B'}."|".$$update{'SUSUDATE'}.  "\n");         
                    }# end for loop - updates
            }
            elsif($table eq "MGMT_E1_CONFIG_USAGE_DATA_INDI")
            {
                    my @indicators = simpleXPathQuery($file, "oracle_e1/config/indicators/indicator");
                    for my $indicator (@indicators)
                    {
                        print("em_result=".$$indicator{'DITYPE'}."|".$$indicator{'DIDL01A'}."|".$release."|".$$indicator{'DIMETRIC'}."|".$$indicator{'DIDL01B'}."|".$$indicator{'DIVALUE1'}."|".$$indicator{'DIVALUE2'}.  "\n");         
                    }# end for loop - indicator
            }

        } # end for loop - topLevelComponents
    } # end if - dump file
            
}
else
{
    EMD_PERL_DEBUG("E1 Dumpfile of type config can only be on windows OS.");
}

EMD_PERL_DEBUG("e1_config  END");



