#!/usr/local/bin/perl
# 
# e1_scf_mc.pl
# 
# Copyright (c) 2002, 2005, Oracle. All rights reserved.  
#
#    NAME
#
#    DESCRIPTION
#      Metric Script for for EnterpriseOne (Former JDEdwards) Server Configuration Framework/Management Console ('scf_mc') data.
#
#    NOTES
#      This script relies on a xml dump file produced by the EnterpriseOne Management Console.
#      There was some perl bug with using a switch statement so if/elsif was used intstead although
#      not as efficient.
#
#    MODIFIED   (MM/DD/YY)
#    kclearwater 10/12/06 - Creation


my ($scriptsDir, $file, $table) = @ARGV;

use strict;
use ias::simpleXPath;
require "$scriptsDir/emd_common.pl";
use Config;

EMD_PERL_DEBUG("e1_scf_mc.pl START");

#windows check.  'e1_scf_mc' is windows only
my $OSNAME = $Config{'osname'};
my $IsWin32 = ($OSNAME eq 'MSWin32');
    
if($IsWin32)
{

    # validate parameters.
    if ((@ARGV) != 3)
    {
        printf "%s\n\n", "Outputs EnterpriseOne Configuration information.";
        printf "%s\n\n", "e1_scf_mc.pl query";
        printf "%s\t%s\n", "  scriptsDir", "Specifies location of CCR scripts.";
        printf "%s\t%s\n", "  file", "Specifies file name of the EnterpriseOne dump file.";
        printf "%s\t%s\n", "  table", "Specifies repository table we are gathering data for.";

    }

    if ($scriptsDir eq '')
    {
        printf "%s\n", "em_warning=The xpath query for was not specified.";
        exit;
    }
    if ($file eq '')
    {
        printf "%s\n", "em_warning=The EnterpriseOne xml dump file was not specified.";
        exit;
    }
    if ($table eq '')
    {
        printf "%s\n", "em_warning=The repository table was not specified.";
        exit;
    }
    
    if( -f $file)
    {
        #EMD_PERL_DEBUG("e1_scf_mc E1 dump file found");
        my @topLevelComponents = simpleXPathQuery($file, "oracle_e1/scf_mc");
        for my $topLevelComponent (@topLevelComponents)
        {
            
            if ($table eq "MGMT_E1_MC_AGENT")
            {
                
                    my @agents = simpleXPathQuery($file, "oracle_e1/scf_mc/agents/agent");
                    for my $agent (@agents)
                    {                    
                        print("em_result=".$$agent{'AGINLOC'}. "\n");                                                                        
                    } # end for loop - agents
            }
            elsif($table eq "MGMT_E1_MC_AGENT_ATTR")
            {
                    my @agentattributes = simpleXPathQuery($file, "oracle_e1/scf_mc/agents/agent/agentattributes/agentattribute");
                    for my $agentattribute (@agentattributes)
                    {
                        print("em_result=".$$agentattribute{'AIINLOC'}."|".$$agentattribute{'AIATTR'}. "|".$$agentattribute{'AIATTRD'}."|".$$agentattribute{'AIATTRV'}. "\n");
                        
                    } # end for loop - agentinstanceprops
                                                
            }
            elsif($table eq "MGMT_E1_MC_MANAGED_HOMES")
            {
                    my @managedhomes = simpleXPathQuery($file, "oracle_e1/scf_mc/agents/agent/managedhomes/managedhome");
                    for my $managedhome (@managedhomes)
                    {                    
                        print("em_result=".$$managedhome{'MHINLOC'}. "|".$$managedhome{'MHMHHOST'}. "|".$$managedhome{'MHMHINLOC'}.  "\n");                   
                    }# end for loop - managedhomes
            }
            elsif($table eq "MGMT_E1_MC_MANAGED_INSTANCES")
            {
                    my @managedinstances = simpleXPathQuery($file, "oracle_e1/scf_mc/agents/agent/managedhomes/managedhome/managedinstances/managedinstance");
                    for my $managedinstance (@managedinstances)
                    {
                        print("em_result=".$$managedinstance{'MIINLOC'}. "|".$$managedinstance{'MIMHHOST'}. "|".$$managedinstance{'MIMHINLOC'}. "|".$$managedinstance{'MIINSTNM'}. "|".$$managedinstance{'MITRGTYP'}."|".$$managedinstance{'MITTDESC'}.  "\n");                                
                    }# end for loop - managedinstances
            }
            elsif($table eq "MGMT_E1_MC_AGENT_JAS_INI")
            {
                    my @agentjasinis = simpleXPathQuery($file, "oracle_e1/scf_mc/agents/agent/agentjasinis/agentjasini");
                    for my $agentjasini (@agentjasinis)
                    {
                        print("em_result=".$$agentjasini{'JIINLOC'}. "|".$$agentjasini{'JISECTION'}."|".$$agentjasini{'JIITEM'}."|".$$agentjasini{'JIVALUE'}.  "\n");                               
                    }# end for loop - agentjasinis
            }
            elsif($table eq "MGMT_E1_MC_AGENT_JDBJ_INI")
            {
                    my @agentjdbjinis = simpleXPathQuery($file, "oracle_e1/scf_mc/agents/agent/agentjdbjinis/agentjdbjini");
                    for my $agentjdbjini (@agentjdbjinis)
                    {
                        print("em_result=".$$agentjdbjini{'JIINLOC'}. "|".$$agentjdbjini{'JISECTION'}."|".$$agentjdbjini{'JIITEM'}."|".$$agentjdbjini{'JIVALUE'}.  "\n");                               
                    }# end for loop - agentjdbjinis
            }

        } # end for loop - topLevelComponents
    } # end if - dump file
            
}
else
{
    EMD_PERL_DEBUG("E1 Dumpfile of type scf_mc can only be on windows OS.");
}

EMD_PERL_DEBUG("e1_scf_mc.pl  END");



