#!/usr/local/bin/perl
# 
# e1_scf_mc_assoc.pl
# 
# Copyright (c) 2002, 2005, Oracle. All rights reserved.  
#
#    NAME
#
#    DESCRIPTION
#      Associations Script for EnterpriseOne (Former JDEdwards) Server Config Framework/Management Console data.
#
#    NOTES
#      This script relies on a xml dump file produced by the EnterpriseOne deployment server.
#      
#
#    MODIFIED   (MM/DD/YY)
#    kclearwater 10/12/06 - Creation


my ($scriptsDir, $file, $table) = @ARGV;

use strict;
use ias::simpleXPath;
require "$scriptsDir/emd_common.pl";
use Config;
use ecmAssoc;

EMD_PERL_DEBUG("e1_scf_mc_assoc.pl START");

#windows check.  'e1_scf_mc_assoc' is windows only
my $OSNAME = $Config{'osname'};
my $IsWin32 = ($OSNAME eq 'MSWin32');
    
if($IsWin32)
{

    # validate parameters.
    if ((@ARGV) != 3)
    {
        printf "%s\n\n", "Outputs EnterpriseOne Management Console Assocations information.";
        printf "%s\n\n", "e1_scf_mc_assoc.pl query";
        printf "%s\t%s\n", "  scriptsDir", "Specifies location of CCR scripts.";
        printf "%s\t%s\n", "  file", "Specifies file name of the EnterpriseOne dump file.";
        printf "%s\t%s\n", "  table", "Specifies repository table we are gathering data for.";

    }

    if ($scriptsDir eq '')
    {
        printf "%s\n", "em_warning=The xpath query for was not specified.";
        exit;
    }
    if ($file eq '')
    {
        printf "%s\n", "em_warning=The EnterpriseOne xml dump file was not specified.";
        exit;
    }
    if ($table eq '')
    {
        printf "%s\n", "em_warning=The repository table was not specified.";
        exit;
    }
    
    if( -f $file)
    {
        #EMD_PERL_DEBUG("e1_scf_mc E1 dump file found");
        my @topLevelComponents = simpleXPathQuery($file, "oracle_e1/scf_mc");
        for my $topLevelComponent (@topLevelComponents)
        {
            
            if ($table eq "MGMT_ECM_ASSOCIATIONS")
            {
                
                    my @managedhomes = simpleXPathQuery($file, "oracle_e1/scf_mc/agents/agent/managedhomes/managedhome");
                    for my $managedhome (@managedhomes)
                    {
                    
                        #managed home install location;host
 
                        printf "em_result=%s|%s|%s|%s\n",
                                $ecmAssoc::CONNECTS_TO,
                                $$managedhome{'MHINLOC'}.";".$$managedhome{'MHMHHOST'},
                                $ecmAssoc::ORACLE_E1_SCF_SA_TYPE,
                                " ";
                    
                    }# end for loop - managedhomes
                    
                    my @managedinstances = simpleXPathQuery($file, "oracle_e1/scf_mc/agents/agent/managedhomes/managedhome/managedinstances/managedinstance");
                    for my $managedinstance (@managedinstances)
                    {
                    
                        #managed home install location;managed home host;target type, instance name
                        
                        my $targetType = $$managedinstance{'MITRGTYP'};
                        $targetType=~ s/^\s*(.*?)\s*$/$1/;
 
                        if ($targetType eq "webserver")
                        {
                        
                            printf "em_result=%s|%s|%s|%s\n",
                                $ecmAssoc::CONNECTS_TO,
                                $$managedinstance{'MIMHINLOC'}.";".$$managedinstance{'MIMHHOST'}.";".$$managedinstance{'MITRGTYP'}.";".$$managedinstance{'MIINSTNM'},
                                $ecmAssoc::ORACLE_E1_SCF_SA_WEBSERVER_TYPE,
                                " ";
                        }
                        elsif($targetType eq "entserver")
                        {
                        
                            printf "em_result=%s|%s|%s|%s\n",
                                $ecmAssoc::CONNECTS_TO,
                                $$managedinstance{'MIMHINLOC'}.";".$$managedinstance{'MIMHHOST'}.";".$$managedinstance{'MITRGTYP'}.";".$$managedinstance{'MIINSTNM'},
                                $ecmAssoc::ORACLE_E1_SCF_SA_ENTSERVER_TYPE,
                                " ";
                        }
                        elsif($targetType eq "pimsynch")
                        {
                        
                            printf "em_result=%s|%s|%s|%s\n",
                                $ecmAssoc::CONNECTS_TO,
                                $$managedinstance{'MIMHINLOC'}.";".$$managedinstance{'MIMHHOST'}.";".$$managedinstance{'MITRGTYP'}.";".$$managedinstance{'MIINSTNM'},
                                $ecmAssoc::ORACLE_E1_SCF_SA_PIMSYNCH_TYPE,
                                " ";
                        }
                        elsif($targetType eq "rteserver")
                        {
                        
                            printf "em_result=%s|%s|%s|%s\n",
                                $ecmAssoc::CONNECTS_TO,
                                $$managedinstance{'MIMHINLOC'}.";".$$managedinstance{'MIMHHOST'}.";".$$managedinstance{'MITRGTYP'}.";".$$managedinstance{'MIINSTNM'},
                                $ecmAssoc::ORACLE_E1_SCF_SA_RTESERVER_TYPE,
                                " ";
                        }
                        elsif($targetType eq "collabportal")
                        {
                        
                            printf "em_result=%s|%s|%s|%s\n",
                                $ecmAssoc::CONNECTS_TO,
                                $$managedinstance{'MIMHINLOC'}.";".$$managedinstance{'MIMHHOST'}.";".$$managedinstance{'MITRGTYP'}.";".$$managedinstance{'MIINSTNM'},
                                $ecmAssoc::ORACLE_E1_SCF_SA_COLLABPORTAL_TYPE,
                                " ";
                        }
                    
                    }# end for loop - managedinstances
                                      
            }   

        } # end for loop - topLevelComponents
    } # end if - dump file
            
}
else
{
    EMD_PERL_DEBUG("E1 Dumpfile of type scf_mc can only be on windows OS.");
}

EMD_PERL_DEBUG("e1_scf_mc_assoc  END");



