#!/usr/local/bin/perl
# 
# e1_scf_sa.pl
# 
# Copyright (c) 2002, 2005, Oracle. All rights reserved.  
#
#    NAME
#
#    DESCRIPTION
#      Metric Script for for EnterpriseOne (Former JDEdwards) Server Configuration Framework/Standalone Agent ('scf_sa') data.
#
#    NOTES
#      This script relies on a xml dump file produced by the EnterpriseOne Standalone Agent.
#      There was some perl bug with using a switch statement so if/elsif was used intstead although
#      not as efficient.
#
#    MODIFIED   (MM/DD/YY)
#    kclearwater 10/26/06 - Creation


my ($scriptsDir, $file, $table) = @ARGV;

use strict;
use ias::simpleXPath;
require "$scriptsDir/emd_common.pl";
use Config;

EMD_PERL_DEBUG("e1_scf_sa.pl START");

  


    # validate parameters.
    if ((@ARGV) != 3)
    {
        printf "%s\n\n", "Outputs EnterpriseOne Configuration information.";
        printf "%s\n\n", "e1_scf_sa.pl query";
        printf "%s\t%s\n", "  scriptsDir", "Specifies location of CCR scripts.";
        printf "%s\t%s\n", "  file", "Specifies file name of the EnterpriseOne dump file.";
        printf "%s\t%s\n", "  table", "Specifies repository table we are gathering data for.";

    }

    if ($scriptsDir eq '')
    {
        printf "%s\n", "em_warning=The xpath query for was not specified.";
        exit;
    }
    if ($file eq '')
    {
        printf "%s\n", "em_warning=The EnterpriseOne xml dump file was not specified.";
        exit;
    }
    if ($table eq '')
    {
        printf "%s\n", "em_warning=The repository table was not specified.";
        exit;
    }

    
    if( -f $file)
    {
        #EMD_PERL_DEBUG("e1_scf_sa E1 dump file found");
        my @topLevelComponents = simpleXPathQuery($file, "oracle_e1/scf_sa");
        for my $topLevelComponent (@topLevelComponents)
        {
            
            if ($table eq "MGMT_E1_SA_AGENT")
            {
                
                    my @agents = simpleXPathQuery($file, "oracle_e1/scf_sa/agents/agent");
                    for my $agent (@agents)
                    {                    
                        print("em_result=".$$agent{'AGINLOC'}. "\n");                                                                        
                    } # end for loop - agents
            }
            elsif($table eq "MGMT_E1_SA_AGENT_ATTR")
            {
                    my @agentattributes = simpleXPathQuery($file, "oracle_e1/scf_sa/agents/agent/agentattributes/agentattribute");
                    for my $agentattribute (@agentattributes)
                    {
                        print("em_result=".$$agentattribute{'AIINLOC'}."|".$$agentattribute{'AIATTR'}. "|".$$agentattribute{'AIATTRD'}."|".$$agentattribute{'AIATTRV'}. "\n");
                        
                    } # end for loop - agentattributes
                                                
            }
            elsif($table eq "MGMT_E1_SA_MAN_INST_ATTR")
            {
                    my @managedinstanceattributes = simpleXPathQuery($file, "oracle_e1/scf_sa/agents/agent/managedinstances/managedinstance/managedinstanceattributes/managedinstanceattribute");
                    for my $managedinstanceattribute (@managedinstanceattributes)
                    {                    
                        print("em_result=".$$managedinstanceattribute{'IIINLOC'}. "|".$$managedinstanceattribute{'IIINSTNM'}. "|".$$managedinstanceattribute{'IITRGTYP'}."|".$$managedinstanceattribute{'IIATTR'}."|".$$managedinstanceattribute{'IIATTRD'}."|".$$managedinstanceattribute{'IIATTRV'}.  "\n");                   
                    }# end for loop - managedinstanceattributes
            }
            elsif($table eq "MGMT_E1_SA_MAN_INST")
            {
                    my @managedinstances = simpleXPathQuery($file, "oracle_e1/scf_sa/agents/agent/managedinstances/managedinstance");
                    for my $managedinstance (@managedinstances)
                    {
                        print("em_result=".$$managedinstance{'MIINLOC'}. "|".$$managedinstance{'MIINSTNM'}. "|".$$managedinstance{'MITRGTYP'}. "|".$$managedinstance{'MITTDESC'}.  "\n");                                
                    }# end for loop - managedinstances
            }
            elsif($table eq "MGMT_E1_SA_MAN_INST_JDE_INI")
            {
                    my @managedinstancejdeinis = simpleXPathQuery($file, "oracle_e1/scf_sa/agents/agent/managedinstances/managedinstance/managedinstancejdeinis/managedinstancejdeini");
                    for my $managedinstancejdeini (@managedinstancejdeinis)
                    {                    
                        print("em_result=".$$managedinstancejdeini{'JIINLOC'}. "|".$$managedinstancejdeini{'JIINSTNM'}. "|".$$managedinstancejdeini{'JITRGTYP'}."|".$$managedinstancejdeini{'JISECTION'}."|".$$managedinstancejdeini{'JIITEM'}."|".$$managedinstancejdeini{'JIVALUE'}.  "\n");
                    }# end for loop - managedinstancejdeinis
            }
            elsif($table eq "MGMT_E1_SA_MAN_INST_JAS_INI")
            {
                    my @managedinstancejasinis = simpleXPathQuery($file, "oracle_e1/scf_sa/agents/agent/managedinstances/managedinstance/managedinstancejasinis/managedinstancejasini");
                    for my $managedinstancejasini (@managedinstancejasinis)
                    {                    
                        print("em_result=".$$managedinstancejasini{'JIINLOC'}. "|".$$managedinstancejasini{'JIINSTNM'}. "|".$$managedinstancejasini{'JITRGTYP'}."|".$$managedinstancejasini{'JISECTION'}."|".$$managedinstancejasini{'JIITEM'}."|".$$managedinstancejasini{'JIVALUE'}.  "\n");
                    }# end for loop - managedinstancejasinis
            }
            elsif($table eq "MGMT_E1_SA_MAN_INST_JDBJ_INI")
            {
                    my @managedinstancejdbjinis = simpleXPathQuery($file, "oracle_e1/scf_sa/agents/agent/managedinstances/managedinstance/managedinstancejdbjinis/managedinstancejdbjini");
                    for my $managedinstancejdbjini (@managedinstancejdbjinis)
                    {                    
                        print("em_result=".$$managedinstancejdbjini{'JIINLOC'}. "|".$$managedinstancejdbjini{'JIINSTNM'}. "|".$$managedinstancejdbjini{'JITRGTYP'}."|".$$managedinstancejdbjini{'JISECTION'}."|".$$managedinstancejdbjini{'JIITEM'}."|".$$managedinstancejdbjini{'JIVALUE'}.  "\n");
                    }# end for loop - managedinstancejdbjinis
            }

        } # end for loop - topLevelComponents
    } # end if - dump file
            

EMD_PERL_DEBUG("e1_scf_sa.pl  END");



