#!/usr/local/bin/perl
# 
# e1_scf_sa_assoc.pl
# 
# Copyright (c) 2002, 2005, Oracle. All rights reserved.  
#
#    NAME
#
#    DESCRIPTION
#      Associations Script for EnterpriseOne (Former JDEdwards) Server Config Framework/Standalone Agent data.
#
#    NOTES
#      This script relies on a xml dump file produced by the Standalone Agent.
#      
#
#    MODIFIED   (MM/DD/YY)
#    kclearwater 10/26/06 - Creation


my ($scriptsDir, $file, $table) = @ARGV;

use strict;
use ias::simpleXPath;
require "$scriptsDir/emd_common.pl";
use Config;
use ecmAssoc;

EMD_PERL_DEBUG("e1_scf_sa_assoc.pl START");

#windows check.  'e1_scf_sa_assoc' is windows only
my $OSNAME = $Config{'osname'};


    # validate parameters.
    if ((@ARGV) != 3)
    {
        printf "%s\n\n", "Outputs EnterpriseOne Management Console Assocations information.";
        printf "%s\n\n", "e1_scf_sa_assoc.pl query";
        printf "%s\t%s\n", "  scriptsDir", "Specifies location of CCR scripts.";
        printf "%s\t%s\n", "  file", "Specifies file name of the EnterpriseOne dump file.";
        printf "%s\t%s\n", "  table", "Specifies repository table we are gathering data for.";

    }

    if ($scriptsDir eq '')
    {
        printf "%s\n", "em_warning=The xpath query for was not specified.";
        exit;
    }
    if ($file eq '')
    {
        printf "%s\n", "em_warning=The EnterpriseOne xml dump file was not specified.";
        exit;
    }
    if ($table eq '')
    {
        printf "%s\n", "em_warning=The repository table was not specified.";
        exit;
    }
    
    if( -f $file)
    {
        #EMD_PERL_DEBUG("e1_scf_sa E1 dump file found");
        my @topLevelComponents = simpleXPathQuery($file, "oracle_e1/scf_sa");
        for my $topLevelComponent (@topLevelComponents)
        {
            
            if ($table eq "MGMT_ECM_ASSOCIATIONS")
            {
                
                    my @managedinstances = simpleXPathQuery($file, "oracle_e1/scf_sa/agents/agent/managedinstances/managedinstance");
                    for my $managedinstance (@managedinstances)
                    {
                    
                        #managed home install location.  ORACLE_E1_SCF_SA_TYPE will be on the same host as the passing target.
                        
                        printf "em_result=%s|%s|%s|%s\n",
                                $ecmAssoc::CONNECTS_TO,
                                $$managedinstance{'MIINLOC'},
                                $ecmAssoc::ORACLE_E1_SCF_SA_TYPE,
                                " ";
                    
                    }# end for loop - managedinstances
                                      
            }   

        } # end for loop - topLevelComponents
    } # end if - dump file
            



EMD_PERL_DEBUG("e1_scf_sa_assoc  END");



