#!/usr/local/bin/perl
# 
# $Header: config_version.pl 02-dec-2005.13:21:51 dkapoor Exp $
#
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      config_version.pl
#
#    DESCRIPTION
#      Get the config and metadata version.
#
#    NOTES
#      
#
#    MODIFIED   (MM/DD/YY)
#    dkapoor     12/02/05 - use ccr/ccr_common 
#    ndutko      10/28/05 - ndutko_ebs_051028_update
#    fle         10/14/05 - Creation
# 

strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/emd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/ccr/ccr_common.pl";

use File::Spec;
use File::Basename;

my ($configFile) = @ARGV;

my $CATEGORY = "[config_version.pl]";

EMD_PERL_DEBUG("$CATEGORY configFile=$configFile");

if (!defined $configFile) {
    exitWithMsg("$CATEGORY Configuration file argument not defined.");
}

if (!(-f $configFile)) {
    exitWithMsg("$CATEGORY The configuration file \"$configFile\" not found.");
}

my ($errMsg1, $installed_version) = getInstalledEBSDBPL_SQLVersion($configFile);
if ($errMsg1 ne "") {
    exitWithMsg($errMsg1);
}

my ($errMsg2, $collected_version) = getConfigProperty($configFile, "META_VER");
if ($errMsg2 ne "") {
    exitWithMsg($CATEGORY . ' ' . $errMsg2);
}

$installed_version = trim($installed_version);
$collected_version = trim($collected_version);
print "em_result=$installed_version|$collected_version\n";



sub exitWithMsg {
    my $errMsg = shift(@_);
    EMD_PERL_ERROR($errMsg);
    print STDERR "em_error=$errMsg";
    exit 1;
}

