#!/usr/local/bin/perl
#
# $Header: contextFilePropsCollector.pl 22-dec-2005.12:12:51 ppradhan Exp $
#
# contextFileVarsCollector.pl
#
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      contextFilePropsCollector.pl 
#
#    DESCRIPTION
#      Arguments:
#        [0] - path to the context file
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#       ppradhan 12/22/05 - modificatiosn to use argument as value for contxt 
#                           file 
#       ppradhan 12/21/05 - for fixing bug 4899850 
#       ndutko   08/03/05 - ndutko_code_checkin
#      ppradhan  05/10/05  -Creation
#

######################################
# Standard Modules
######################################

use strict;
use English;
use Carp;

require 5.005;

######################################
# Package Specific Modules
######################################

#
# Not all of these packages have to be included but are listed to provide
# a complete reference.
#

use TXK::XML();
use TXK::Common();
use hostOSD;

######################################
# Object Keys
######################################

my $FILE_NAME      = "file";

my $contextFile = $ARGV[0];

_debug("ARG0:" . $contextFile . "\n");

my $xmlObj = TXK::XML->new();
$xmlObj->loadDocument( { $FILE_NAME => $contextFile  } );

# now print output
# bug fix for bug 4899850
my $ctx_path = $contextFile;
# end bug fix for bug 4899850
my $node_name = $xmlObj->getOAVar('s_hostname');
if ((! defined $node_name) || $node_name eq "")
{
  $node_name = hostOSD::getHostName();
}
my $ctx_name = $xmlObj->getOAVar('s_contextname');
my $ctx_type = substr($xmlObj->getOAVar('s_contexttype'),0,1);
my $version = $xmlObj->getAttrValue({node=>'oa_context',attrname=>'version'});

print "em_result=",$ctx_path,'|',$node_name,'|',$ctx_name,'|',$ctx_type,'|',$version,"\n";


#
# Debug print
#
sub _debug{
  my($strToPrint) = @_;
  #print "$strToPrint \n";
} #End debug
