#!/usr/local/bin/perl
#
# $Header: emll/sysman/admin/scripts/ebs/contextFileVarsCollector.pl /main/4 2009/03/12 11:47:17 rlandows Exp $
#
# contextFileVarsCollector.pl
#
# Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
#
#    NAME
#      contextFileVarsCollector.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      Arguments:
#        [0] - path to the context file
#        [1] - category to collect oa_var info for. Possible values are:
#              "oa_context"       -> global variables
#              "oa_system"        -> system variables
#              "oa_host"          -> host variables
#              "oa_install"       -> install variables
#              "oa_environments"  -> environment variables
#              "oa_processes"     -> process variables
#              "oa_customized"    -> custom variables
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#       ppradhan 12/22/05 - modificatiosn to use argument as value for contxt 
#                           file 
#       ppradhan 12/21/05 - for fixing bug 4899850 
#       ndutko   08/03/05 - ndutko_code_checkin
#      ppradhan  05/09/05  -Creation
#       rlandows 03/11/09 - Added substr for 7172295

######################################
# Standard Modules
######################################

use strict;
use English;
use Carp;

require 5.005;

######################################
# Package Specific Modules
######################################

#
# Not all of these packages have to be included but are listed to provide
# a complete reference.
#

use TXK::XML();
use TXK::Common();
use hostOSD;

######################################
# Object Keys
######################################

my $FILE_NAME      = "file";

#my $contextFile = $ENV{CONTEXT_FILE};
my $contextFile = $ARGV[0];
my $rootCategory = $ARGV[1];

_debug("ARG0:" . $contextFile . "\n");
_debug("ARG1:" . $rootCategory . "\n");

my $xmlObj = TXK::XML->new();
$xmlObj->loadDocument( { $FILE_NAME => $contextFile  } );

my $xmltree = $xmlObj->getDocument();
my $oa_hash = { };

# load oa_var info
_load_oavar($xmltree, $oa_hash, "", "", 0);

# now print output
# bug fix for bug 4899850
my $ctx_path = $contextFile;
# end bug fix for bug 4899850
my $node_name = $xmlObj->getOAVar('s_hostname');
if ((! defined $node_name) || $node_name eq "")
{
  $node_name = hostOSD::getHostName();
}
my $key;
my $oa_var_hash = $oa_hash->{$rootCategory};

foreach $key (keys %$oa_var_hash)
{
  
  my $oa_var_info = $oa_var_hash->{$key} ;

  print "em_result=", $ctx_path, '|', $node_name ;
 
  my $entry;
  foreach $entry (@$oa_var_info)
  {
      print '|', substr($entry,0,3999);
  }
  print "\n";
  
}

#
# loads oa_var related information into an hash of arrays. Each array
# will contain the following information:
# 0. oa_var
# 1. oa_type if available
# 2. oa_var_value
# 3. oa_var_name i.e node name for the oa_var
# 4. category - parent category to which the oa_var belongs
# 5. root_category - the root category to which the oa_var belongs.
#
sub _load_oavar
{
  my $xmltree = $ARG[0];
  my $oa_hash = $ARG[1];
  my $category = $ARG[2];
  my $root_category = $ARG[3];
  my $level = $ARG[4];

  my $child_category = $category;
  my $child_root_category = $root_category;

  my ($obj,$name,$key);

  
  my @oa_var_info;

   foreach $obj (@$xmltree)
   {
     my ($var_name,$var_value,$oa_type,$oa_nd_name,$type);
     $oa_nd_name = $obj->{'head'};
     foreach $name ( @{$obj->{'names'}} )
      {
        foreach $key ( keys %$name )
         {
           if ( $key eq "oa_var" )
            {
              $var_name = $name->{$key};

              $var_name =~ s/\'//g;
              $var_name =~ s/\"//g;

#	Set emtpy body if not defined.

              $obj->{'body'}->[0] = " " if not defined ($obj->{'body'}->[0]) ;

              $var_value= ($obj->{'body'}->[0]);

            }
	   if ( $key eq "oa_type" )
	   {
	     $oa_type = $name->{$key};

	     $oa_type =~ s/\'//g;
	     $oa_type =~ s/\"//g;
           }
	   if ( $key eq "type" )
	   {
	     $type = $name->{$key};

	     $type =~ s/\'//g;
	     $type =~ s/\"//g;
           }
         }
      }

    if ($var_name)
    {
  #print $var_name , '|' , $oa_type , '|' , "$var_value" , '|' , $oa_nd_name , '|' , $category , '|' , $root_category , '|' , $level , "\n";

      $oa_hash->{$root_category} = { } if not defined ($oa_hash->{$root_category}) ;
      
      push @{$oa_hash->{$root_category}->{$var_name}}, ($var_name,$oa_type,$var_value,$oa_nd_name,$category);

    }   


     if ( $obj->{'is_inner'} )
      {
        # determine child categories for recursive call
        if ($level eq "0" or $level eq "1")
        {
	  $child_root_category = $oa_nd_name;    
        }
        $child_category = $oa_nd_name;	  
	if ($type)
        {
	    $child_category = $child_category . ':' . $type;
        }

        _load_oavar($obj->{'body'},$oa_hash,$child_category,$child_root_category,$level+1);
      }
   }
}

#
# Debug print
#
sub _debug{
  my($strToPrint) = @_;
  #print "$strToPrint \n";
} #End debug
