#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ebs/ebsCustMetricCollector.pl /main/4 2009/09/24 07:43:04 aghanti Exp $
#
# configMetricCollector.pl
# 
# Copyright (c) 2005, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ebsCustMetricCollector.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#       aghanti  05/26/09 - Open the LL file in proper encoding
#       ndutko   01/24/08 - Require the ccr_common module for
#                           getConfigProperty()
#       glavash  12/14/07 - add parse_db_metric
#       ppradhan 06/02/06 - For fixing metrics for compatibility between 
#                           10.2.2 and 10.2.3 
#       ppradhan 06/02/06 - For fixing metrics for compatibility between 
#                           10.2.2 and 10.2.3 
#       ppradhan 06/02/06 - Created for fixing bug 5264451. Copied from
#                          configMetricCollector.pl
# 
require "$ENV{EMDROOT}/sysman/admin/scripts/emd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/ccr/ccr_common.pl";

my ($configFile) = @ARGV;

my $oracle_home = $ENV{EM_TARGET_ORACLE_HOME};
my $target_type = $ENV{TYPE};
my $metric = $ENV{Metric};

EMD_PERL_INFO("In configMetricCollector for  oh=[$oracle_home], configfile=[$configFile] , SID=[$sid] and metric=[$metric]");

if (!defined $configFile )
{
    EMD_PERL_INFO("em_error=The livelink configuration file not passed.");
    print STDERR "em_error=The livelink configuration file not passed.\n";
    exit (-1);
}
if( !(-f $configFile))
{
    print STDERR "em_error=The livelink configuration file \"$configFile\" not found.\n";
    exit (-1);
}
my $columnCount = $ENV{MetricColumnCount};
my $sid = $ENV{SID};
my $sid_qualifier = "";
$sid_qualifier = ":$sid" if  (defined $sid && $sid ne "");

my $dbScriptVersion = getConfigProperty($configFile,"META_VER");

#Get the db charset and map it to corresponding perl encoding
my $llOpenMode = getLLFileOpenMode($configFile);

my $found = 0;
if(open(CONFIG_FILE_READER, $llOpenMode, $configFile))
{
    my $line;
    my $endMarker;
    my $lastResult = '';
    while($line = <CONFIG_FILE_READER>)
    {
        chomp($line);
	if($found)
	{
        	if ($line =~ /^$endMarker/)
		{
            		printResult($lastResult);
            		last; # found the metric end, exit the loop
		}
		else
		{
	    		if($line =~ /^em_result=/)
            		{
				#New result starts here, print the last result
				# and re-initialize the last result with this
				# line
            			printResult($lastResult);
				$lastResult=$line;
            		}
			else
			{
				#Append the last result with
				#this line using a space character.
				$lastResult= $lastResult . " " . $line;
			}
			EMD_PERL_INFO("Processed:$line");
		}
	}
	else
	{
        	if ($line =~ /^$metric(.*):Begin/)
        	{
			# Found the start if (in precedence) 
			# - metric has a matching sid qualifier
			# - sid qualifier is empty  or 
			# - metric does not have sid qualifier or 
			if( $1 eq $sid_qualifier || $sid_qualifier eq "" 
				|| $1 eq "")
			{
            			#Found the metric start, 
            			$found = 1;
				$endMarker = "$metric$1:End";
            			next;
			}
        	}
	}
    }
}
else
{
    EMD_PERL_INFO("Could not open the config file");
    print STDERR "em_error=Could not open the configuration file=\"$configFile\":$!\n";
    exit (-1);
}

sub printResult
{
  my ($result) = @_;

  if(length($result) != 0)
  {
    #
    # Bug fix for bug: 5264451
    #

    #
    # Check if we're currently processing 'cust_request_sets' or 
    # 'other_customizations'. If yes, check if the actual number
    # of columns is less than the expected number i.e. we've hit
    # the issue where collector is at 10.2.3 level and the ll file
    # is at 10.2.2 level. If yes, shift the columns to the right
    # and place an empty first column. 
    #
    if ($metric eq "cust_request_sets" || $metric eq "other_customizations")
    {
      EMD_PERL_INFO("Encountered metric:$metric");
      my $startsWith = "em_result=";
      my $startsWith_len = length($startsWith);
      if ($result =~ /^em_result=/)
      {
	my $line = substr($result,$startsWith_len,length($result)-$startsWith_len);
        my @cols = parse_db_metric($result,$dbScriptVersion);

        $numCols = @cols;
        
        EMD_PERL_INFO("Actual columns:$numCols expected columns:$columnCount");

        if ($numCols == $columnCount - 1)
        { # actual number of columns is 1 less than the expected columns
        
          # add a extra seperator at start of result
          $result =~ s/^em_result=/em_result=|/;
          EMD_PERL_INFO("Reconstructed result:$result");
	}
      }      
    }
    print "$result\n";
    EMD_PERL_INFO("Printed:$result");
  }
}
