#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ebs/ebsHPPNotAppliedCollector.pl /main/6 2009/09/24 07:43:04 aghanti Exp $
#
# ebsHPPNotAppliedCollector.pl
# 
# Copyright (c) 2006, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ebsHPPNotAppliedCollector.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    aghanti     05/26/09 - Open the LL file in proper encoding
#    ndutko      01/24/08 - Require the ccr_common module for
#                           getConfigProperty()
#    glavash     12/14/07 - add check for column count
#    glavash     12/14/07 - use parse_db_metric
#    ndutko      07/31/07 - Movement of metricdata to data directory
#    ppradhan    09/17/06 - Script for collecting ebiz high priority patches
#                           not applied
#    ppradhan    09/17/06 - Creation
# 
require "$ENV{EMDROOT}/sysman/admin/scripts/emd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/net/listenerUtil.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/ccr/ccr_common.pl";

my ($configFile) = @ARGV;

my $oracle_home = $ENV{EM_TARGET_ORACLE_HOME};
my $metric = $ENV{Metric};
my $columnCount = $ENV{MetricColumnCount};
my $sid = $ENV{SID};
my $logcat = "[ebsHPPNotAppliedCollector]";
my $sid_qualifier = "";
$sid_qualifier = ":$sid" if  (defined $sid && $sid ne "");

my $aru_release_name;
my $hpp_data_file;
my %ad_bugs_data;
my @hpp_data;

EMD_PERL_INFO("In $logcat for  oh=[$oracle_home], configfile=[$configFile] , SID=[$sid] and metric=[$metric]");

if (!defined $configFile )
{
    EMD_PERL_INFO("em_error=The livelink configuration file not passed.");
    print STDERR "em_error=The livelink configuration file not passed.\n";
    exit (-1);
}
if( !(-f $configFile))
{
    print STDERR "em_error=The livelink configuration file \"$configFile\" not found.\n";
    exit (-1);
}

#
# Evaluate the aru release name by looking at the ll file.
#
$aru_release_name = getARUReleaseName($configFile);


#
# Get the ebs high priority patches csv file name.
# if the file does not exist, exit without error
#
$hpp_data_file = getHPPCSVFileName($configFile,$aru_release_name);


if( !(-f $hpp_data_file))
{
    EMD_PERL_INFO("$logcat Unable to locate file $hpp_data_file");
    exit (0);
}

#
# Load ad_bugs data 
#
loadAdBugsData($configFile,$aru_release_name);

#
# Load ebs HPP data
#
loadHPPData($hpp_data_file);

#
# Compare and print the patches in ebs HPP data not found in ad_bugs
#
printHPPNotApplied($aru_release_name);

#
# Prints a single row for the metric result
#
sub printResult
{
  my ($result) = @_;

  if(length($result) != 0)
  {
    print "$result\n";
    EMD_PERL_INFO("Printed:$result");
  }
}

#
# Computes the HPP patches that are not applied and prints the
# results.
#
sub printHPPNotApplied
{
  my ($ver) = @_;
  debug("IN printHPPNotApplied: $ver");
  # loop through the hpp data and check if the given entry
  # exists in the ad bugs data. If not we've found a patch not yet
  # applied on this system.
  my $count = 0;
  foreach (@hpp_data)
  {
    my $hpp = $_;
    debug("printHPPNotApplied: Processing $hpp");
    if (! exists $ad_bugs_data{$hpp} )
    {
      debug("printHPPNotApplied Found Not Applied: $hpp");
      my @hpp_entries = split(/\,/,$hpp);
      
      # print result in format:
      # em_result=<bugnumber>|<arureleasename>|<baseline>
      my $hpp_result = "em_result=" . $hpp_entries[0] . "|" . $hpp_entries[1];
      if (defined $hpp_entries[2])
      {
        # baseline entry exists
	$hpp_result = $hpp_result . "|" . $hpp_entries[2];
      }
      else
      {
        # baseline did not exist, use release as baseline.
	$hpp_result = $hpp_result . "|" . $ver;
      }
      printResult($hpp_result);
      $count = $count + 1;
    }
  }
  debug("printHPPNotApplied: Located $count not applied patches.");
  debug("OUT printHPPNotApplied: $ver");
}

#
# Loads entries in ad_bugs for a given release into a global hash
#
# Parameters 1) apps ll file name
#            2) aru release name
#         
#
sub loadAdBugsData
{
  my ($db_ll_file,$ver) = @_;
  debug("IN loadAdBugsData: $db_ll_file");
  my $metric = "ad_bugs";
  my $found = 0;
  my $dbScriptVersion = getConfigProperty($db_ll_file,"META_VER");

  #Get the db charset and map it to corresponding perl encoding
  my $llOpenMode = getLLFileOpenMode($db_ll_file);

  if(open(CONFIG_FILE_READER, $llOpenMode, $db_ll_file))
  {
    my $line;
    my $endMarker;
    my $lastResult = '';
    my $bugno;
    my $rel;
    my $baseline;
    my $key;
    my $count = 0;
    while($line = <CONFIG_FILE_READER>)
    {
        chomp($line);
	if($found)
	{
        	if ($line =~ /^$endMarker/)
		{
            		last; # found the metric end, exit the loop
		}
		else
		{
	    	   if($line =~ /^em_result=.*/)
                   {
                      my @col_values = parse_db_metric($line,$dbScriptVersion);
                      if (scalar(@col_values) >= 3 )
                      {
			   # if the ad_bug row is for current release load it
			   $bugno = trim($col_values[0]);
                           $rel = trim($col_values[1]);
                           $baseline = trim($col_values[2]);

                           # load only if we're looking at a bug entry
                           # for the relevant release. This is in order
                           # to avoid loading too many rows in memory as
			   # R12 can contains both 11i and R12 entries in
			   # ad_bugs.
                           if ($ver eq $rel)
                           {
			     # If 11i, load only bugno and rel
			     # otherwise load, bugno, rel and baseline
			     if ($rel eq "11i")
			     {
			       $key = $bugno . "," . $rel;
			     }
			     else
			     {
			       $key = $bugno . "," . $rel . "," . $baseline;
			     }
                             $ad_bugs_data{$key} = $key;
                             $count = $count + 1;
                           }
		       }
                   }
		}
	}
	else
	{
        	if ($line =~ /^$metric(.*):Begin/)
        	{
			# Found the start if (in precedence) 
			# - metric has a matching sid qualifier
			# - sid qualifier is empty  or 
			# - metric does not have sid qualifier or 
			if( $1 eq $sid_qualifier || $sid_qualifier eq "" 
				|| $1 eq "")
			{
            			#Found the metric start, 
            			$found = 1;
				$endMarker = "$metric$1:End";
            			next;
			}
		}
	}
     }
     debug("loadAdBugsData: Loaded $count ad_bug entries.");
    }
  close(CONFIG_FILE_READER);
  debug("OUT loadAdBugsData: $db_ll_file");
}


#
# Loads entries in HPP data file into an array
#
# Parameters 1) HPP CSV file name
#         
#
sub loadHPPData
{
  my ($csv_file) = @_;
  debug("IN loadHPPData: $csv_file");
  if(open(CONFIG_FILE_READER, $csv_file))
  {
    my $line;
    my $key;
    my $count = 0;
    while($line = <CONFIG_FILE_READER>)
    {
        chomp($line);		
	if($line =~ /^ebshpp=(.*)/)
        {
	  $key = trim($1);
          # add entry to our hpp data array
          push(@hpp_data,$key);
          $count = $count + 1;  
	} 
    }
    debug("loadHPPData: Loaded $count HPP entries.");
  }
  close(CONFIG_FILE_READER);
  debug("OUT loadHPPData: $csv_file");
}

#
# Returns the applications base release from the LL file
#
# Parameters 1) apps ll file name and patch
#         
# Returns a scalar that is the base release e.g. 11.5.10, 12.0.0 etc.
#
sub getAppsReleaseFromLL
{
  my ($db_ll_file) = @_;
  my $apps_release;

  my $metric = "apps_summary";
  my $found = 0;
  debug("In getAppsReleaseFromLL: $db_ll_file");
 
  my $dbScriptVersion = getConfigProperty($db_ll_file,"META_VER"); 

  #Get the db charset and map it to corresponding perl encoding
  my $llOpenMode = getLLFileOpenMode($db_ll_file);

  if(open(CONFIG_FILE_READER, $llOpenMode, $db_ll_file))
  {
    my $line;
    my $endMarker;
    while($line = <CONFIG_FILE_READER>)
    {
      chomp($line);
      if($found)
      {
        if ($line =~ /^$endMarker/)
        {
          last; # found the metric end, exit the loop
        }
        elsif ($line =~ /[^\x09\x20-\x7E]/)
        {# skip lines with oddball/nonprintables?
	  debug("Ignoring Result containing non printables :em_result=$line");
	  next;
        }
	elsif($line !~ /^em_result=/)
        {
	  debug("Ignoring Result the result is not in new line:$line");
	  next;
        }
        my @col_values = parse_db_metric($line,$dbScriptVersion);
	$apps_release = trim($col_values[1]);
	debug("Found apps release: $1");
      }
      elsif ($line =~ /^$metric:Begin/)
      {
        #Found the metric start, 
        $found = 1;
        $endMarker = "$metric:End";
	debug("Found Start -> $1");
      }
    }
  }
  close(CONFIG_FILE_READER);

  debug("Out getAppsReleaseFromLL");
  return $apps_release; 
}

#
# Returns the ARU release name based on apps release in the ll file
#
# Parameters 1) apps ll file name
#
# Returns a scalar that is the ARU release name e.g. 11i, R12
#
sub getARUReleaseName
{
  my ($db_ll_file) = @_;
  
  debug("In getARUReleaseName: $db_ll_file");
  my $apps_release = getAppsReleaseFromLL($db_ll_file);
  my $ver = $apps_release;
  if ($apps_release =~ /^11/)
  {
    $ver = "11i";
  }
  elsif ($apps_release =~ /^12/)
  {
    $ver = "R12";
  }
  debug("getARUReleaseName: Evaluated ARU Relese Name: $ver");
  debug("OUT getARUReleaseName: $db_ll_file");
  return $ver;
}

#
# Returns the HPP CSV file name based on the apps release in the ll file
#
# Parameters 1) apps ll file name
#            2) aru release name e.g. 11i or R12
#         
# Returns a scalar that is the full path to the EBS HPP csv data file.
#
sub getHPPCSVFileName
{
  my ($db_ll_file,$ver) = @_;
  
  debug("In getHPPCSVFileName: $db_ll_file");
  
  my $ebs_hpp_file = $ENV{EMDROOT} . "/data/" . "ebs_highpriority_" . $ver . ".csv";  

  debug("getHPPCSVFileName: Evaluated CSV Filename: $ebs_hpp_file");

  debug("Out getHPPCSVFileName: $db_ll_file");
  return $ebs_hpp_file;
}

#
# Debug print to standard out
# 
sub debug
{
  my ($str) = @_;
#  print $str . "\n";
  EMD_PERL_DEBUG($str . "\n");
}
