#!/usr/local/bin/perl
# 
# $Header: ebs_assoc_common.pl 08-apr-2008.08:43:48 rlandows Exp $
#
# ebs_assoc_common.pl
# 
# Copyright (c) 2006, 2008, Oracle. All rights reserved.  
#
#    NAME
#      ebs_assoc_common.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rlandows    04/08/08 - to fix bug 6897188
#    ndutko      01/24/08 - Fixup of code issues for association collections
#                           introduced in 10.2.7.1.0
#    glavash     12/14/07 - add check for column count
#    glavash     12/13/07 - use parse_db_metric
#    pparida     10/17/07 - XbranchMerge pparida_bug-6492554 from
#                           st_emll_10.2.7
#    pparida     10/15/07 - Fix bug 6492554: Use CCR_CONFIG_HOME for OCM log,
#                           state and config dirs.
#    ppradhan    03/09/06 - To add API to get apps db target properties from 
#                           ll file 
#    ppradhan    03/08/06 - Common APIs for generating association metrics 
#    ppradhan    03/08/06 - Common APIs for generating association metrics 
#    ppradhan    03/08/06 - Creation
# 

######################################
# Standard Modules
######################################

require 5.005;

######################################
# Package Specific Modules
######################################

#
# Not all of these packages have to be included but are listed to provide
# a complete reference.
#

#
# relationship types are defined in ecmassoc.pm
#
use Sys::Hostname;


######################################
# Object Keys
######################################

require "$ENV{EMDROOT}/sysman/admin/scripts/db/net/listenerUtil.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/ccr/ccr_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/semd_common.pl";

#
# Returns the DB target properties either host::sid or host::servicename
# from the DB ll file
#
# Parameters 1) DBName 
#            2) IsRAC - TRUE or FALSE
#         
# Returns a scalar of form either host::sid (if database is single instance)
# or host::servicename (if rac database)
#
sub getDbTgtPropFromLL
{
  my ($db_name, $isRAC) = @_;
  my $hostName = hostname();
  my $db_ll_file = $ENV{CCR_CONFIG_HOME} . "/state/" . $db_name;
  my $db_target_props;
  if (defined $isRAC && $isRAC =~ /^TRUE$/i)
  {
    $db_ll_file = $db_ll_file . "-RAC.ll";
    # get service name
    @initParamNames = ("SERVICE_NAMES");
    my %initParamsTable = getInitParams($db_ll_file,@initParamNames);
    my $service_names = $initParamsTable{"SERVICE_NAMES"};
  
    $db_target_props = $hostName . "::" . $service_names;
  }
  else
  {
    # single instance db so get the sid
    $db_ll_file = $db_ll_file . ".ll";
    my %sidTable = getSidsFromDBll($db_ll_file);
    my $db_sid;
    my $sid;
    for $sid (keys %sidTable)
    {
      if (&equalHosts($sidTable{$sid}, $hostName))
      {
        $hostName = $sidTable{$sid};
        $db_sid = $sid;
        last;
      }
    }
    $db_target_props = $hostName . "::" . $db_sid; 
  }
  return $db_target_props; 
}


#
# Returns the Apps DB target properties as hostname:apps_system_name by
# reading the apps-db ll file
#
# Parameters 1) DBName 
#            2) IsRAC - TRUE or FALSE
#         
# Returns a scalar of form either host::sid (if database is single instance)
# or host::servicename (if rac database)
#
sub getAppsDbTgtPropFromLL
{
  my ($db_name, $isRAC) = @_;
  my $hostName = hostname();
  my $apps_system_name;
  my $db_ll_file = $ENV{CCR_CONFIG_HOME} . "/state/" . $db_name;
  my $db_target_props;
  my $dbScriptVersion;

  if (defined $isRAC && $isRAC =~ /^TRUE$/i)
  {
    $db_ll_file = $db_ll_file . "-RAC-apps_db.ll";
   
  }
  else
  {
    $db_ll_file = $db_ll_file . "-apps_db.ll"; 
  }

  my $metric = "apps_summary";
  my $found = 0;
  EMD_PERL_DEBUG("In getAppsDbTgtPropFromLL: $db_ll_file");
 
  #6897188, renamed CONFIG_FILE_READER because getConfigProperty also
  #uses and closes CONFIG_FILE_READER. 
  if(open(RCONFIG_FILE_READER, $db_ll_file))
  {
    my $line;
    my $endMarker;

    $dbScriptVersion = getConfigProperty($db_ll_file,"META_VER");

    my @col_values;

    while($line = <RCONFIG_FILE_READER>)
    {
      chomp($line);
      if($found)
      {
        if ($line =~ /^$endMarker/)
        {
          last; # found the metric end, exit the loop
        }
        elsif ($line =~ /[^\x09\x20-\x7E]/)
        {# skip lines with oddball/nonprintables?
	  EMD_PERL_DEBUG("Ignoring Result containing non printables :em_result=$line");
	  next;
        }
	elsif($line !~ /^em_result=/)
        {
	  EMD_PERL_DEBUG("Ignoring Result the result is not in new line:$line");
	  next;
        }

        #6897188, use @ instead of $ on line below
        @col_values = parse_db_metric($line,$dbScriptVersion);

        # original code was looking for 
        #   if ($line =~ /^em_result=(.*?)\|(.*?)\|(.*?)\|(.*?)\|(.*?)/)
        if (scalar(@col_values) >= 5)
        {
          $apps_system_name = trim($col_values[0]);     
	  EMD_PERL_DEBUG("Found apps system name: $apps_system_name");
        }
      }
      elsif ($line =~ /^$metric:Begin/)
      {
        #Found the metric start, 
        $found = 1;
        $endMarker = "$metric:End";
	EMD_PERL_DEBUG("Found Start -> $1");
      }
    }
  }
  close(RCONFIG_FILE_READER);

  $db_target_props = $hostName . ":" . $apps_system_name;
  EMD_PERL_DEBUG("Target Props: $db_target_props");

  EMD_PERL_DEBUG("Out getAppsDbTgtPropFromLL");
  return $db_target_props; 
}
