#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ebs/livelink/configMetricCollector.pl /main/2 2009/09/24 07:43:04 aghanti Exp $
#
# configMetricCollector.pl
# 
# Copyright (c) 2005, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      configMetricCollector.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    aghanti     05/26/09 - Open the LL file in proper encoding
#    ndutko      08/03/05 - ndutko_code_checkin
#    dkapoor     04/04/05 - Creation
# 
require "$ENV{EMDROOT}/sysman/admin/scripts/emd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/ccr/ccr_common.pl";

my $oracle_home = $ENV{EM_TARGET_ORACLE_HOME};
my $db_name = $ENV{DBName};
EMD_PERL_INFO("In configMetricCollector for oh=[$oracle_home] and db_name=[$db_name]");
my $metric = $ENV{Metric};
my $configFile = "$oracle_home/livelink/data/$db_name"."_ebs.ll";
EMD_PERL_INFO("In configMetricCollector for [$configFile] and [$metric]");

if (!defined $configFile )
{
    EMD_PERL_INFO("em_error=The livelink configuration file not passed.");
    print STDERR "em_error=The livelink configuration file not passed.\n";
    exit (-1);
}
if( !(-f $configFile))
{
    print STDERR "em_error=The livelink configuration file \"$configFile\" not found.\n";
    exit (-1);
}
my $columnCount = $ENV{MetricColumnCount};

#Get the db charset and map it to corresponding perl encoding
my $llOpenMode = getLLFileOpenMode($configFile);

my $found = 0;
if(open(CONFIG_FILE_READER, $llOpenMode, $configFile))
{
        my $line;
        while($line = <CONFIG_FILE_READER>)
        {
                chomp($line);
                if ($line =~ /^$metric:End/)
                {
				last; # found the metric end, exit the loop
		}
                if ($line =~ /^$metric:Begin/)
                {
				#found the metric start, read the data from the next line
				$found = 1;
				next;
		}
                if($found)
                {
                         print "em_result=$line\n";
                         EMD_PERL_INFO("em_result=$line");
                }
        }
}
else
{
    EMD_PERL_INFO("Could not open the config file");
    print STDERR "em_error=Could not open the configuration file=\"$configFile\":$!\n";
    exit (-1);
}
