# $Header: oracle_apps_cm_assoc.pl 12-oct-2007.12:03:27 jsutton Exp $
#
# Copyright (c) 2005, 2007, Oracle. All rights reserved.  
#
# NAME
#   oracle_apps_cm_assoc.pl
#
# DESCRIPTION
#   Returns targets associated with this oracle_apps_cm instance
#
#   List of standard assocation types are in ecmAssoc.pm
#
#   Returns potentially multiple 
#     em_result=association_type|target_name|target_type|target_properties
#
#
#     association_type: one of the types listed in ecmAssoc.pm
#     target_name: the target_name of the associated target
#     target_type: the target_type of the associated target
#     target_properties: related information that may help determine true target name given the target_type
#
# NOTES
#
# MODIFIED     (MM/DD/YY)
# jsutton       10/12/07 - XbranchMerge jsutton_bug-6498627 from st_emll_10.2.7
# ppradhan      03/09/06 - Adding hostname:apps_system_name as target property 
#                          for apps db target 
# ppradhan      03/08/06 - creating target properties for associations 
# glavash       10/28/05 - change DEPENDS_ON to MEMBER_OF bug 4708128 
# fle           10/17/05 - Check if RAC. 
# fle           10/14/05 - Append '_apps_db' to target name. 
#

require 5.005;

use ecmAssoc; # relationship types are defined in ecmassoc.pm

require "$ENV{EMDROOT}/sysman/admin/scripts/ebs/ebs_assoc_common.pl";

my ($configFile) = @ARGV;
my $dbName = $ENV{DBName};
my $isRAC = $ENV{ISRAC};

my $db_target_props = getDbTgtPropFromLL($dbName,$isRAC);
my $apps_db_target_props = getAppsDbTgtPropFromLL($dbName,$isRAC);

my $dbTargetType = $ecmAssoc::ORACLE_DATABASE_TYPE;
if (defined $isRAC && $isRAC =~ /^true$/i) {
  $dbTargetType = $ecmAssoc::RAC_DATABASE_TYPE;
}

# Print out the results
# em_result=association_type|target_name|target_type|target_property
print "em_result=",$ecmAssoc::CONNECTS_TO,'|',$dbName,'|',$dbTargetType,'|',$db_target_props,"\n";
print "em_result=",$ecmAssoc::MEMBER_OF,'|',$dbName . '_apps_db','|','oracle_apps_db','|',$apps_db_target_props,"\n";

