# $Header: oracle_apps_cm_inf_assoc.pl 13-mar-2007.13:40:48 ppradhan Exp $
#
# Copyright (c) 2005, 2007, Oracle. All rights reserved.  
#
# NAME
#   oracle_apps_inf_assoc.pl
#
# DESCRIPTION
#   Returns targets associated with this oracle_apps_inf instance
#
#   List of standard assocation types are in ecmAssoc.pm
#
#   Returns potentially multiple:
#     em_result=association_type|target_name|target_type|target_properties
#     where:
#       association_type: one of the types listed in ecmAssoc.pm
#       target_name: the target_name of the associated target
#       target_type: the target_type of the associated target
#       target_properties: related information that may help determine true target name given the target_type
#
# NOTES
#
# MODIFIED     (MM/DD/YY)
# ppradhan      03/13/07 - fix for bug 5878098
# ppradhan      03/09/06 - changing apps db target props to 
#                          hostname:appsysname 
# ppradhan      03/08/06 - Fix for bug 5035399 
# fle           10/17/05 - Check if RAC.
# fle           10/12/05 - Checked context file existent. Define target name.
# fle           09/11/05 - Created
#

require 5.005;
require "$ENV{CCR_HOME}/sysman/admin/scripts/emd_common.pl";

#
# Not all of these packages have to be included but are listed to provide
# a complete reference.
#

use TXK::XML();
use TXK::Common();

#
# relationship types are defined in ecmassoc.pm
#
use ecmAssoc;

my $contextFile = $ARGV[0];
if (!(-e $contextFile)) {
  EM_PERL_ERROR("*** Ignore this error if this is NOT IAS_ORACLE_HOME ***\nContext file not found: $contextFile.");
  die "Context file not found: $contextFile.";
}

my $xmlObj = TXK::XML->new();
$xmlObj->loadDocument( { "file" => $contextFile } );

# Get information for oracle_apps_db target
my $app_system_name = $xmlObj->getOAVar('s_systemname');

# Get information for oracle_database target
my $db_host = $xmlObj->getOAVar('s_dbhost');
my $db_domain = $xmlObj->getOAVar('s_dbdomain');
my $db_port = $xmlObj->getOAVar('s_dbport');
my $db_sid = $xmlObj->getOAVar('s_dbSid');

my $db_host_port_sid = $db_host . '.' . $db_domain . ':' . $db_port . ':' . $db_sid;

my $target_name;

# Get DB target type.
my $jdbcConnDesc = $xmlObj->getOAVar('s_apps_jdbc_connect_descriptor');
my $dbTargetType = $ecmAssoc::ORACLE_DATABASE_TYPE;
my $count = 0;
$count++ while $jdbcConnDesc =~ /\(ADDRESS=/g;
if ($count > 1) {
  $dbTargetType = $ecmAssoc::RAC_DATABASE_TYPE;
  $db_host_port_sid = $db_host . '.' . $db_domain . ':' . $db_port . ':' . $xmlObj->getOAVar('s_dbGlnam');
}

# Bugfix for bug 5878098
# Added target properties for hostname and oracle home
my $hostname = $xmlObj->getOAVar('s_hostname');
my $hostdomain = $xmlObj->getOAVar('s_domainname');
my $ias_oh = $xmlObj->getOAVar('s_weboh_oh');
my $ias_tp = $hostname . '.' . $hostdomain . ':' . $ias_oh;


# Print out the results
# em_result=association_type|target_name|target_type|target_property
print "em_result=",$ecmAssoc::CONNECTS_TO,'|',$target_name,'|',$dbTargetType,'|',$db_host_port_sid,"\n";
print "em_result=",$ecmAssoc::MEMBER_OF,'|',$target_name,'|',"oracle_apps_cm",'|',$db_host_port_sid,"\n";
my $systemName = $xmlObj->getOAVar('s_systemname');
my $contextName = $xmlObj->getOAVar('s_contextname');
$target_name = "$systemName:Infrastructure($contextName)";
print "em_result=",$ecmAssoc::DEPENDS_ON,'|',$target_name,'|',"oracle_apps_inf",'|',$ias_tp,"\n";

