# $Header: oracle_apps_db_assoc.pl 08-mar-2006.15:16:06 ppradhan Exp $
#
# Package : hostAssoc.pl
#
# Copyright (c) 2005, 2006, Oracle. All rights reserved.  
#
#   NAME
#       oracle_apps_db_assoc.pl
#
#   DESCRIPTION
#       Returns targets associated with this oracle_apps_db instance
#
#   List of standard assocation types are in
#   ecmAssoc.pm
#
#   returns potentially multiple 
# em_result=association_type|target_name|target_type|target_properties
#
#
# association_type: one of the types listed in ecmAssoc.pm
# target_name: the target_name of the associated target
# target_type: the target_type of the associated target
# target_properties: related information that may help determine true target name given the target_type
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      ppradhan    03/08/06 - creating target properties for association 
#      ndutko      08/03/05 - ndutko_code_checkin
#      ppradhan    05/26/05 - Created from oracle_apps_inf.pl
##*************************************************************

######################################
# Standard Modules
######################################

require 5.005;

######################################
# Package Specific Modules
######################################

#
# Not all of these packages have to be included but are listed to provide
# a complete reference.
#

#
# relationship types are defined in ecmassoc.pm
#
use ecmAssoc;
use File::Basename;

######################################
# Object Keys
######################################

require "$ENV{EMDROOT}/sysman/admin/scripts/ebs/ebs_assoc_common.pl";

my ($configFile) = @ARGV;

my $assoc_depends_on = $ecmAssoc::DEPENDS_ON;
my $assoc_connects_to = $ecmAssoc::CONNECTS_TO;

my $oracle_database_type = $ecmAssoc::ORACLE_DATABASE_TYPE;
my $rac_database_type = $ecmAssoc::RAC_DATABASE_TYPE;

my $db_name = $ENV{DBName};
my $isRAC = $ENV{ISRAC};

my $db_target_props = getDbTgtPropFromLL($db_name,$isRAC);

# Get information for oracle_apps_db target

# Print out the results
# em_result=association_type|target_name|target_type|target_property
if (defined $db_name)
{
	my $dbTargetType = $oracle_database_type;
	if(defined $isRAC && $isRAC =~ /^TRUE$/i)
	{
		$dbTargetType = $rac_database_type;
	}
  	print "em_result=",$assoc_connects_to,'|',$db_name,'|',$dbTargetType,'|',$db_target_props,"\n";
}


#
# Debug print
#
sub _debug{
  my($strToPrint) = @_;
  #print "$strToPrint \n";
} #End debug


# End of the Program
