# $Header: oracle_apps_inf_assoc.pl 09-mar-2006.23:41:03 ppradhan Exp $
#
# Package : hostAssoc.pl
#
# Copyright (c) 2005, 2006, Oracle. All rights reserved.  
#
#   NAME
#       oracle_apps_inf_assoc.pl
#
#   DESCRIPTION
#       Returns targets associated with this oracle_apps_inf instance
#
#   List of standard assocation types are in
#   ecmAssoc.pm
#
#   returns potentially multiple 
# em_result=association_type|target_name|target_type|target_properties
#
#
# association_type: one of the types listed in ecmAssoc.pm
# target_name: the target_name of the associated target
# target_type: the target_type of the associated target
# target_properties: related information that may help determine true target name given the target_type
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#   ppradhan      03/09/06 - changing apps db target props to 
#                            hostname:appsysname 
#   ppradhan      03/08/06 - Fix for bug 5035399 
#   glavash       10/28/05 - change DEPENDS_ON to MEMBER_OF bug 4708128 
#   fle           10/17/05 - Check if RAC.
#      ppradhan    05/24/05 - Created from hostAssoc.pl
##*************************************************************

######################################
# Standard Modules
######################################

require 5.005;

######################################
# Package Specific Modules
######################################

#
# Not all of these packages have to be included but are listed to provide
# a complete reference.
#

use TXK::XML();
use TXK::Common();

#
# relationship types are defined in ecmassoc.pm
#
use ecmAssoc;

######################################
# Object Keys
######################################

my $FILE_NAME      = "file";
my $assoc_depends_on = $ecmAssoc::DEPENDS_ON;
my $assoc_member_of = $ecmAssoc::MEMBER_OF;
my $assoc_connects_to = $ecmAssoc::CONNECTS_TO;

my $contextFile = $ARGV[0];

_debug("ARG0:" . $contextFile . "\n");

my $xmlObj = TXK::XML->new();
$xmlObj->loadDocument( { $FILE_NAME => $contextFile  } );

# Get information for oracle_apps_db target
my $app_system_name = $xmlObj->getOAVar('s_systemname');

# Get information for oracle_database target
my $db_host = $xmlObj->getOAVar('s_dbhost');
my $db_domain = $xmlObj->getOAVar('s_dbdomain');
my $db_port = $xmlObj->getOAVar('s_dbport');
my $db_sid = $xmlObj->getOAVar('s_dbSid');

my $db_host_port_sid = $db_host . '.' . $db_domain . ':' . $db_port . ':' . $db_sid;

# Get information for the oracle_apps_db target
my $apps_db_props = $db_host . ":" . $app_system_name;
 
# Get information for oracle_ias target
my $hostname = $xmlObj->getOAVar('s_hostname');
my $hostdomain = $xmlObj->getOAVar('s_domainname');
my $ias_oh = $xmlObj->getOAVar('s_weboh_oh');

my $ias_tp = $hostname . '.' . $hostdomain . ':' . $ias_oh;

my $target_name;

my $jdbcConnDesc = $xmlObj->getOAVar('s_apps_jdbc_connect_descriptor');
my $dbTargetType = $ecmAssoc::ORACLE_DATABASE_TYPE;
my $count = 0;
$count++ while $jdbcConnDesc =~ /\(ADDRESS=/g;
if ($count > 1) {
  $dbTargetType = $ecmAssoc::RAC_DATABASE_TYPE;
  $db_host_port_sid = $db_host . '.' . $db_domain . ':' . $db_port . ':' . $xmlObj->getOAVar('s_dbGlnam');
}

# Print out the results
# em_result=association_type|target_name|target_type|target_property
print "em_result=",$assoc_member_of,'|',$target_name,'|',"oracle_apps_db",'|',$apps_db_props,"\n";
print "em_result=",$assoc_connects_to,'|',$target_name,'|',$dbTargetType,'|',$db_host_port_sid,"\n";
print "em_result=",$assoc_depends_on,'|',$target_name,'|',"oracle_ias",'|',$ias_tp,"\n";

#
# Debug print
#
sub _debug{
  my($strToPrint) = @_;
  #print "$strToPrint \n";
} #End debug


# End of the Program
