# $Header: oracle_apps_reports_assoc.pl 27-feb-2007.21:04:47 ppradhan Exp $
#
# Copyright (c) 2005, 2007, Oracle. All rights reserved.  
#
# NAME
#   oracle_apps_reports_assoc.pl
#
# DESCRIPTION
#   Returns targets associated with this instance
#
#   List of standard assocation types are in ecmAssoc.pm
#
#   Returns potentially multiple:
#     em_result=association_type|target_name|target_type|target_properties
#     where:
#       association_type: one of the types listed in ecmAssoc.pm
#       target_name: the target_name of the associated target
#       target_type: the target_type of the associated target
#       target_properties: related information that may help determine true target name given the target_type
#
# NOTES
#
# MODIFIED     (MM/DD/YY)
# ppradhan      02/27/07 - Bug fix for bug 5878098
# ppradhan      05/19/06 - Changing relations 
# ppradhan      05/18/06 - test revert 
# ppradhan      05/18/06 - changing depends on to member of 
# fle           10/12/05 - Check context file existent. Define target name.
# fle           09/11/05 - Created
#

# TODO: Verify if CCR_HOME env is set at this point.
require "$ENV{CCR_HOME}/sysman/admin/scripts/emd_common.pl";

use TXK::XML();
use TXK::Common();
use ecmAssoc; # Relationship types are defined in ecmassoc.pm

my $contextFile = $ARGV[0];
if (!(-e $contextFile)) {
  EM_PERL_ERROR("*** Ignore this error if this is NOT IAS_ORACLE_HOME ***\nContext file not found: $contextFile.");
  die "Context file not found: $contextFile.";
}

my $xmlObj = TXK::XML->new();
$xmlObj->loadDocument( { "file" => $contextFile } );

# Print out the results
# em_result=association_type|target_name|target_type|target_property
my $systemName = $xmlObj->getOAVar('s_systemname');
my $contextName = $xmlObj->getOAVar('s_contextname');
# TODO: Hardcode the target name until we decide the target properties.
my $targetName = "$systemName:Infrastructure($contextName)";

# Bugfix for bug 5878098
# Added target properties for hostname and oracle home
my $hostname = $xmlObj->getOAVar('s_hostname');
my $hostdomain = $xmlObj->getOAVar('s_domainname');
my $ias_oh = $xmlObj->getOAVar('s_weboh_oh');
my $ias_tp = $hostname . '.' . $hostdomain . ':' . $ias_oh;

print "em_result=",$ecmAssoc::MEMBER_OF,'|',$targetName,'|',"oracle_apps_inf",'|',$ias_tp,"\n";

