#!/usr/local/bin/perl
#
# $Header: txkInventoryWrapper.pl 10.1 2005/10/26 23:17:08 fle noship $
#
# Copyright (c) 2004, 2005, Oracle. All rights reserved.
#
#    NAME
#      txkInventoryWrapper.pl 
#
#    DESCRIPTION
#      Arguments:
#        [0] - full perl command to execute txkInventory.pl
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    fle         10/26/05 - Strip all leading/trailing spaces and change 'e_r' to 'em_result'.
#      ppradhan  06/10/05  -Creation
#

use strict;

my $txk_cmd = $ARGV[0];

my $txk_cmd_output = readpipe $txk_cmd;

my @lines = split(/\n+/, $txk_cmd_output);
foreach my $line (@lines) {
  if ($line =~ /^\s*e_r=/) {
    my @tkns = split(/\|/,$line);
    foreach my $tkn (@tkns) {
      $tkn =~ s/^\s*|\s*$//;
    }
    $line = join("|", @tkns) . "\n";
    # Change 'e_r=' to 'em_result='.
    $line =~ s/^e_r=/em_result=/;
    # Print back the result.
    print $line;
  }
}

