# $Header: ecmErrorMsgs.pm 21-mar-2004.11:45:04 mgoodric Exp $
#
# Package : ecmErrorMsgs.pm
#
# Copyright (c) 2002, 2004, Oracle Corporation.  All rights reserved.
#
#   NAME
#       ecmErrorMsgs.pm
#
#   DESCRIPTION
#       Centralized Subroutine to throw error messages
#       from perl programs. This is created
#       1. to reduce the number of error msgs by reusing
#       2. to make NLSsizing easier
#
#       Try to use existing error messages. If necessary,
#       add new error messages.
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      mgoodric   03/21/04 - Linux cleanup
#      mgoodric   04/07/03 - fix finding MAC address
#      goramamo   01/21/03 - Add new messages
#      rmenon     10/19/02 - rmenon_bug_fixes_and_rt_changes
#      goramamo   09/03/02 - Created
#
##*************************************************************

use strict;

package ecmErrorMsgs;

use Carp;
require 5.005;

#require 5.6.1;
require Exporter;

#******************************************
#   Export Subroutines
#******************************************

@ecmErrorMsgs::ISA    = ('Exporter');
@ecmErrorMsgs::EXPORT = qw(
  &throwECMError
  );

#******************************************
#     Global Variables
#******************************************
#     Error Messages
#******************************************

$ecmErrorMsgs::Msg{'CmdNotFound'} =    #
  ": Command not found or not executable.";
$ecmErrorMsgs::Msg{'FileNotFound'} =    #
  ": No such file or directory.";
$ecmErrorMsgs::Msg{'PackNotFound'} =    #
  ": Packages and Patches details cannot be collected.";
$ecmErrorMsgs::Msg{'Failed'} =          #
  "failed.";

$ecmErrorMsgs::Msg{'NotNumber'} =       #
  "is not numeric.";
$ecmErrorMsgs::Msg{'Null'} =            #
  "is null.";

$ecmErrorMsgs::Msg{'OpenFailure'} =     #
  ": Could Not Open/read this file/directory.";
$ecmErrorMsgs::Msg{'CloseFailure'} =    #
  ": Could Not close this file/directory.";
$ecmErrorMsgs::Msg{'NoArgs'} =          #
  ": No/Wrong arguments passed in Host Configuration Collection.";

$ecmErrorMsgs::Msg{'NotAbleToCollect'} =    #
  ": Could not able to collect this information.";
$ecmErrorMsgs::Msg{'UndefinedSubroutine'} =    #
  "was never defined.";
$ecmErrorMsgs::Msg{'PassedArguments'} =        #
  "are the argument(s) passed.";
$ecmErrorMsgs::Msg{'UnknownComponent'} =       #
  ": Components with no names are listed under UNKNOWN product name.";

#******************************************
#   Exported Subroutines
#******************************************

sub throwECMError($;$)
{

    # Usage comments
    # can be called from any perl program to throw error message

    # Usage: throwECMError('arg0',"arg1");
    # arg0 : Keyword for error. This is converted to equivalent detail
    #      : message shown above. The above detailed messages are
    #      : to be NLSsized in future. This canNOT be NULL.
    # arg1 : System File/Command/Utility/Metric which was being accessed
    #      : and not EM program name. If you are not sure, you can
    #      : leave this as blank. This is not language specific
    #      : and need (and can) not be NLSsized.
    # Example:
    # Usage: throwECMError('FileNotFound','/usr/sbin/ifconfig');

    my ($arg0,$arg1) = @_;

    print STDERR "$arg1 $ecmErrorMsgs::Msg{$arg0}\n";

    # Example
    # print STDERR "/usr/sbin/ifconfig : No such file or directory\n";

    return;
}

1;

# End of the Program
