#!/usr/local/bin/perl
# 
# $Header: emcaDbUtil.pl 27-jan-2005.04:31:21 rahgupta Exp $
#
# emcaDbUtil.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      emcaDbUtil.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rahgupta    01/27/05 - rahgupta_bug-4017590_main
#    rahgupta    01/23/05 - Creation
# 

# Usage $0 ORACLE_HOME ORACLE_SID DB_USER DB_ROLE SQL NO_OF_PARAMS_TO_BIND PARAM_NAME. 
# DB_PWD passed in stdin as DB_PWD=dbPwd.
# Params to bind should be passed in stdin as PARAM_NAME=PARAM_VALUE.

use strict;
use Oraperl;
use DBI;
use DBI qw(:sql_types);

require "emd_common.pl";

my @argArray = @ARGV;
print "Arguments passed @argArray \n\n";

if ( scalar ( @argArray ) < 5 )
{
  print "Usage: \n";
  print "$0 ORACLE_HOME ORACLE_SID DB_USER DB_ROLE SQL NO_OF_PARAMS_TO_BIND PARAM_NAME \n";
  print "DB_PWD passed in stdin as DB_PWD=dbPwd \n";
  print "Params to bind should be passed in stdin as PARAM_NAME=PARAM_VALUE \n";
  exit 1;
}

my %stdinArgs = get_stdinvars();

my $oracleHome = $argArray[0];
shift @argArray;
my $oracleSid = $argArray[0];
shift @argArray;
my $dbUser = $argArray[0];
shift @argArray;
my $dbRole = $argArray[0];
shift @argArray;
my $dbPwd = $stdinArgs{"DB_PWD"};
my $sql = $argArray[0];
shift @argArray;
my $noOfParams = $argArray[0];
shift @argArray;

# If the the role is SYSDBA, user is SYS and PWD is not supplied
# then use OS authentication through bequeath.
if ( // =~ "$dbPwd" && $dbRole =~ /\bSYSDBA\b/i && $dbUser =~ /\bSYS\b/i )
{
  $dbUser = "";
}

# We need to connect as SYS user using SYSDBA logon.
my $mode = 0;
if ( $dbRole =~ /SYSDBA/i )
{
  $mode = 2;
}

# We need to connect using bequeath connection in order to make use of OS authentication.
# hence set the env variable ORACLE_HOME and ORACLE_SID
$ENV{ORACLE_HOME} = $oracleHome;
$ENV{ORACLE_SID} = $oracleSid;

print ( "Connecting to database $oracleSid in home $oracleHome with user \"$dbUser\" role \"$dbRole\". \n" );

my $lda;
#DBI->trace ( 4, 'dbiTrace.log' );
$lda = DBI->connect('dbi:Oracle:', "$dbUser", "$dbPwd",
                            {ora_session_mode => $mode,
                             PrintError => 0,
                             RaiseError => 0}) or die "Couldn't connect to the db. ";
print "connected to database. \n";
print "sql to execute $sql \n";

my $sth = $lda->prepare($sql) or die "Couldn't prepare statement: " . $lda->errstr;

my $cntr = 0;
my $name;
my $value;

print ( "noOfParams to bind: $noOfParams. \n" );
for ( $cntr = 1 ; $cntr <= $noOfParams ; ++$cntr )
{
  $name  = $argArray[0];
  shift @argArray;
  $value = $stdinArgs { $name };

  $sth->bind_param ( $cntr, $value );
}

$sth->execute () or die "Couldn't execute statement: " . $sth->errstr;
$sth->finish ();

print "sql execute successfully. \n";

$lda->disconnect ();

exit 0;

