# $Header: emll/sysman/admin/scripts/emdConfiguration.pl /main/11 2010/12/10 01:23:57 rstorrie Exp $
#
# Package : emdConfiguration.pl
#
# Copyright (c) 2002, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#     emdConfiguration.pl 
#
#   DESCRIPTION
#       Collects the agent configuration information
#
#   returns EM_RESULT =
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#     rstorrie   12/09/10 - Change the location of JAVA to ORACLE_HOME rather
#                           than CONFIG_HOME
#     rstorrie   05/18/10 - Add config home as a collected value
#     rstorrie   03/22/10 - The mapping for the PERL parameters is wrong
#     bkchoudh   03/18/10 - Fixed Bug 9463248,changed exe to bat, called callEmctl
#     rstorrie   03/09/10 - Bug 8984993 Make use of new generic callEmctl
#                           routine
#     raankire   02/12/10 - Change of collectConfig sub, added secure_status
#     rstorrie   09/18/09 - Fix java version on windows by adding .exe to the
#                           file extension
#     raankire   06/04/09 - Change of collectJava sub, Added Java Version
#     rstorrie   11/23/05 - Change of PERCENT_FLOOR 
#     rstorrie   11/22/05 - Creation
##*************************************************************

use strict;
use File::Spec;
use Switch;
require "$ENV{EMDROOT}/sysman/admin/scripts/emd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/ccr/ccr_common.pl";

my $agentConfigRoot = shift;
my $ll_oracle_home = shift;
my $collectionType = shift;

$ENV{LL_ORACLE_HOME} = $ll_oracle_home;

# Setup a reference table for all the valid parameters. This allows us to check if 
# the parameter is one we wish to collect.    
my $refPropertyMap = {    'EMD_URL' => 'EMD_URL',
                          'agentVersion' => 'VERSION',
                          'REPOSITORY_URL' => 'REP_URL',
                          'agentTZRegion' => 'AGENT_TZ',
                          'UploadInterval' => 'UPLOAD_INT',
                          'UploadFailBackoffPct' => 'UPLOAD_BACKOFF_PERCENT',
                          'UploadTimeout' => 'UPLOAD_TIMEOUT',
                          'UploadMaxTime' => 'UPLOAD_MAXTIME',
                          'UploadFileSize' => 'UPLOAD_FILE_SIZE',
                          'UploadMaxBytesXML' => 'UPLOAD_MAX_BYTES_XML',
                          'UploadMaxNumberXML' => 'UPLOAD_MAX_NUMBER_XML',
                          'UploadMaxDiskUsedPct' => 'UPLOAD_MAX_DISK_USED_PERCENT',
                          'UpUploadMaxDiskUsedPctFloor' => 'UPLOAD_MAX_DISK_USED_FLOOR',
                          'DbHangTimeout' => 'DB_HANG_TIMEOUT',
                          'AgentListenOnAllNICs' => 'AGENT_LISTEN_ALL_NICS',
                          'emdFailureScript' => 'FAILURE_SCRIPT',
                          'emd_email_address' => 'EMAIL_ADDRESS',
                          'emd_email_gateway' => 'EMAIL_GATEWAY',
                          'emd_from_email_address' => 'EMAIL_FROM_ADDRESS',
			  'SecureStatus' => 'SECURE_STATUS',
                          'NormalThreadStackSize' => 'NORMAL_THREAD_STACK',
                          'ThreadPoolModel' => 'THREAD_POOL_MODEL',
                          'IgnoreSignals' => 'IGNORE_SIGNALS',
                          'enableMetricBrowser' => 'METRIC_BROWSER',
                          'disableRemoteOperations' => 'DISABLE_REMOTE_OPERATIONS',
                          'RemoteAPITimeout' => 'REMOTE_API_TIMEOUT',
                          'altAdminPath' => 'ALT_ADMIN_PATH',
                          'MaxHealthMonitorThreads' => 'MAX_HEALTH_MONITOR_THREADS',
                          'SSLSessionCache' => 'SSL_SESSION_CACHE',
                          'httpTimeoutPrimaryHeader' => 'HTTP_PRIMARY_TIMEOUT',
                          'httpTimeoutSecondaryHeaders' => 'HTTP_SECONDARY_TIMEOUT',
                          'httpTimeoutBody' => 'HTTP_BODY_TIMEOUT',
                          'dynamicPropsComputeTimeout' => 'DYNAMIC_PROP_TIMEOUT',
                          'dynamicPropsComputeTimeout_rac_database' => 'DYNAMIC_RAC_TIMEOUT',
                          'dynamicPropsComputeTimeout_oracle_database' => 'DYNAMIC_DB_TIMEOUT',
                          'OMS_VERSION' => 'OMS_VERSION',
                          'OMS_CHARSET' => 'CHARSET',
                          'OMS_PROTOCOL_VERSION' => 'PROTOCOL_VER',
                          'JAVA_HOME' => 'JAVA_HOME',
                          'CLASSPATH' => 'CLASSPATH',
                          'hostConfigClasspath' => 'HOST_CLASSPATH',
                          'JAVA_OPTIONS' => 'JAVA_OPTIONS',
                          'agentJavaDefines' => 'AGENT_DEFINES',
                          'perlBin' => 'PERL_BIN',
                          'EMAGENT_PERL_TRACE_LEVEL' => 'PERL_TRACE_LEVEL',
                          'EMAGENT_PERL_TRACE_DIR' => 'PERL_TRACE_DIR',
                          'EMAGENT_PERL_TRACE_SIZE' => 'PERL_TRACE_SIZE',
                          'LogFileWithPID' => 'LOG_FILE_PID',
                          'LogFileMaxSize' => 'LOG_FILE_MAX_SIZE',
                          'LogFileMaxRolls' => 'LOG_FILE_MAX_ROLLS',
                          'TrcFileMaxSize' => 'TRACE_FILE_MAX_SIZE',
                          'TrcFileMaxRolls' => 'TRACE_FILE_MAX_ROLLS'};
    
SWITCH:
{
    $collectionType eq "config" && do 
    {
        collectConfig();
    	last SWITCH;
    };
    $collectionType eq "java" && do
    {
    	collectJava();
    	last SWITCH;
    };
    $collectionType eq "perl" && do
    {
    	collectPerl();
    	last SWITCH;
    };
    $collectionType eq "log" && do
    {
    	collectLogandTrace();
    	last SWITCH;
    };
    die "No valid parameter supplied, exiting\n";
}



# Procedure to collect all the configuration parameters
sub collectConfig()
{
    my %configParams;        
    my $property;
    
    # Need emd.properties to assign the configuration parameters
    my $emd_properties_file = File::Spec->catfile( $agentConfigRoot, "sysman", "config", "emd.properties" );
    # Need protocol.ini for the protocol versions
    my $protocol_ini_file = File::Spec->catfile( $agentConfigRoot, "sysman", "emd", "protocol.ini" );

    if (-f $emd_properties_file)
    {
        open (FILE, "<$emd_properties_file") or EMD_PERL_DEBUG("Unable to open $! \n",$emd_properties_file);
        my $line; 
       
        #Scan through the file assigning the various parameters to get the values
        while ($line = <FILE>)
        {
    	    chomp $line;           
            if ( $line =~ /^\s*(.*?)\s*=\s*(.*?)$/) 
            {
                $property = $refPropertyMap->{$1};                
                if ( exists($refPropertyMap->{$1}) )
                {
            	    $configParams{"$property"}=$2;
                }
            }
        }
        close FILE;
    }
    if  (-f $protocol_ini_file)  
    {
        # Now parse the protocol.ini to get that
        open (FILE, "<$protocol_ini_file") or EMD_PERL_DEBUG("Unable to open $! \n",$protocol_ini_file);
        my $line;
        while ($line = <FILE>)
        {
    	    chomp $line;
    	    if ( $line =~ /^\s*(.*?)\s*=\s*(.*?)$/) 
            {
                $property = $refPropertyMap->{$1};                
                if ( exists($refPropertyMap->{$1}) )
                {
            	    $configParams{"$property"}=$2;
                }
            }
        }
        close FILE;
    }
    my @agentVersion = callEmctl("getversion");
    my $versionString;
    my $version='';
    foreach $versionString (@agentVersion)
    {
        chomp ($versionString);
        if ($versionString =~ /Agent Version ([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)/)
        {
                $version = $1;
                last;
        }
    }

##Added for secure_status
                my $i;
                my $line_str;
                my $secure_found;
                my $unsecure_found;
                my $secure_search="agent is secure";
                my $unsecure_search="agent is unsecure";
                my @output_agent_sec;
                @output_agent_sec = callEmctl("status agent -secure");

                EMD_PERL_DEBUG("For emctl agent secure command, Please see the following output");

                foreach $i (0..($#output_agent_sec)) 
                {
                   $line_str=$output_agent_sec[$i];
                   EMD_PERL_DEBUG("$line_str \n");
                   $line_str=lc($line_str);
                   $secure_found=rindex $line_str,$secure_search;
                   if ($secure_found >= 0) 
                   {
                       $configParams{"SECURE_STATUS"}=$output_agent_sec[$i];
                   }
                   if ($secure_found == -1) 
                   {
                      $unsecure_found=rindex $line_str,$unsecure_search;
                      if ($unsecure_found >= 0) 
                      {
                         $configParams{"SECURE_STATUS"}=$output_agent_sec[$i];
                      }
                  }
                }
 # remove the CR from the agent output
 chomp $configParams{"SECURE_STATUS"} if(defined($configParams{"SECURE_STATUS"}));
##End of secure_status

    # Print the results of the configuration parameters
    print "em_result=" . $configParams{"EMD_URL"} . "|" 
                       . $version . "|"
                       . $configParams{"REP_URL"} . "|"
                       . $configParams{"AGENT_TZ"} . "|"
                       . $configParams{"METRIC_BROWSER"} . "|"
                       . $configParams{"UPLOAD_INT"} . "|"
                       . $configParams{"UPLOAD_BACKOFF_PERCENT"} . "|"
                       . $configParams{"UPLOAD_TIMEOUT"} . "|"
                       . $configParams{"UPLOAD_MAXTIME"} . "|"
                       . $configParams{"UPLOAD_FILE_SIZE"} . "|"
                       . $configParams{"UPLOAD_MAX_BYTES_XML"} . "|"
                       . $configParams{"UPLOAD_MAX_NUMBER_XML"} . "|"
                       . $configParams{"UPLOAD_MAX_DISK_USED_PERCENT"} . "|"
                       . $configParams{"UPLOAD_MAX_DISK_USED_FLOOR"} . "|"
                       . $configParams{"DB_HANG_TIMEOUT"} . "|"
                       . $configParams{"AGENT_LISTEN_ALL_NICS"} . "|"
                       . $configParams{"DISABLE_REMOTE_OPERATIONS"} . "|"
                       . $configParams{"REMOTE_API_TIMEOUT"} . "|"
                       . $configParams{"ALT_ADMIN_PATH"} . "|"
                       . $configParams{"MAX_HEALTH_MONITOR_THREADS"} . "|"
                       . $configParams{"SSL_SESSION_CACHE"} . "|"
                       . $configParams{"HTTP_PRIMARY_TIMEOUT"} . "|"
                       . $configParams{"HTTP_SECONDARY_TIMEOUT"} . "|"
                       . $configParams{"HTTP_BODY_TIMEOUT"} . "|"
                       . $configParams{"DYNAMIC_PROP_TIMEOUT"}. "|"
                       . $configParams{"DYNAMIC_RAC_TIMEOUT"}. "|"
                       . $configParams{"DYNAMIC_DB_TIMEOUT"}. "|"
                       . $configParams{"FAILURE_SCRIPT"}. "|"
                       . $configParams{"OMS_VERSION"}. "|"
                       . $configParams{"CHARSET"} . "|"
                       . $configParams{"PROTOCOL_VER"}. "|"
                       . $configParams{"EMAIL_ADDRESS"}. "|"
                       . $configParams{"EMAIL_GATEWAY"}. "|"                   
                       . $configParams{"EMAIL_FROM_ADDRESS"}. "|"    
		       . $configParams{"SECURE_STATUS"}. "|"
		       . $agentConfigRoot . "\n";
}

# Procedure to collect Java parameters
sub collectJava()
{
    my %javaParams;
    my $property;
    my @java_version;
	
    # Need emd.properties to assign the java parameters
    my $emd_properties_file = File::Spec->catfile( $agentConfigRoot, "sysman", "config", "emd.properties" );
    my $classpath_file = File::Spec->catfile( $agentConfigRoot, "sysman", "config", "classpath.lst" );

    #Need java file to check the java version 
    my $java_jre_file = File::Spec->catfile( $ll_oracle_home,"jdk", "jre","bin","java" );
    my $java_jdk_file = File::Spec->catfile( $ll_oracle_home,"jdk","bin","java" );
  
    if (-f $emd_properties_file)
    {
        open (FILE, "<$emd_properties_file") or EMD_PERL_DEBUG("Unable to open $! \n",$emd_properties_file);
        my $line;
        while ($line = <FILE>)
        {
    	    chomp $line;
    	    if ( $line =~ /^\s*(.*?)\s*=\s*(.*?)$/) 
            {
                $property = $refPropertyMap->{$1};                
                if ( exists($refPropertyMap->{$1}) )
                {
            	    $javaParams{"$property"}=$2;
                }
            }    	                            
        }
        close FILE;
    }
    #Get the extra classpath entries from integrators
    if (-f $classpath_file)
    {
    	open (FILE, "<$classpath_file") or EMD_PERL_DEBUG("Unable to open $! \n",$classpath_file);
    	my $line;
        while ($line = <FILE>)
        {
        	chomp $line;        	
        	if ( $line =~ /^(\/.*?)$/)
        	{        		
        		$javaParams{"CLASSPATH"} = $javaParams{"CLASSPATH"} . ":" . $1;
        	}
        }
        close FILE;
    }
    #Get the Java Version
    if ((-f $java_jre_file) || (-f $java_jre_file.".exe"))
    {
	my $java_version_out = `$java_jre_file -version 2>&1` or EMD_PERL_DEBUG("Unable to execute JAVA VERSION : $! \n",$java_jre_file);
	@java_version = split(/"/, $java_version_out);
    }
    elsif ((-f $java_jdk_file) || (-f $java_jdk_file.".exe"))
    {
	my $java_version_out = `$java_jdk_file -version 2>&1` or EMD_PERL_DEBUG("Unable to execute JAVA VERSION : $! \n",$java_jdk_file);
        @java_version = split(/"/, $java_version_out);
    }	
 
    # Print the results of the java parameters
    print "em_result=" . $javaParams{"JAVA_HOME"} . "|"
                       . $javaParams{"CLASSPATH"} . "|"
                       . $javaParams{"HOST_CLASSPATH"} . "|"
                       . $javaParams{"JAVA_OPTIONS"} . "|"
		       . $javaParams{"AGENT_DEFINES"} . "|" 
		       . $java_version[1] . "\n";
}

# Procedure to collect Perl parameters
sub collectPerl()
{
    my %perlParams;
    my $property;
	
    # Need emd.properties to assign the perl parameters
    my $emd_properties_file = File::Spec->catfile( $agentConfigRoot, "sysman", "config", "emd.properties" );
    
    if (-f $emd_properties_file)
    {
        open (FILE, "<$emd_properties_file") or EMD_PERL_DEBUG("Unable to open $! \n",$emd_properties_file);
        my $line;
        while ($line = <FILE>)
        {
    	    chomp $line;
    	    if ( $line =~ /^\s*(.*?)\s*=\s*(.*?)$/) 
            {
                $property = $refPropertyMap->{$1};                
                if ( exists($refPropertyMap->{$1}) )
                {
            	    $perlParams{"$property"}=$2;
                }
            }              
        }
        close FILE;
    }
    # Print the results of the perl parameters
    print "em_result=" . $perlParams{"PERL_BIN"} . "|"
                       . $perlParams{"PERL_TRACE_LEVEL"} . "|"
                       . $perlParams{"PERL_TRACE_DIR"} . "|"
                       . $perlParams{"PERL_TRACE_SIZE"} . "\n";
} # end CollectPerl

sub collectLogandTrace()
{
    my %logParams;
    my $property;
	
    # Need emd.properties to assign the perl parameters
    my $emd_properties_file = File::Spec->catfile( $agentConfigRoot, "sysman", "config", "emd.properties" );

    if (-f $emd_properties_file)
    {
        open (FILE, "<$emd_properties_file") or EMD_PERL_DEBUG("Unable to open $! \n",$emd_properties_file);
        my $line;
        while ($line = <FILE>)
        {
    	    chomp $line;
            if ( $line =~ /^\s*(.*?)\s*=\s*(.*?)$/) 
            {
                $property = $refPropertyMap->{$1};                
                if ( exists($refPropertyMap->{$1}) )
                {
            	    $logParams{"$property"}=$2;
                }
            } 
        }
        close FILE;
    }
    # Print the results of the perl parameters
    print "em_result=" . $logParams{"LOG_FILE_PID"} . "|"
                       . $logParams{"LOG_FILE_MAX_SIZE"} . "|"
                       . $logParams{"LOG_FILE_MAX_ROLLS"} . "|"
                       . $logParams{"TRACE_FILE_MAX_SIZE"} . "|"
                       . $logParams{"TRACE_FILE_MAX_ROLLS"} . "\n";
} # end collectLogandTrace
