# $Header: emdinfo.pl 28-dec-2004.13:48:43 xxu Exp $
#
# emdinfo.pl
# 
# Copyright (c) 2002, 2004, Oracle. All rights reserved.  
#
#    NAME
#      emdinfo.pl - Info about the emd itself
#
#    DESCRIPTION
#      Gives information about the emd itself. Like the userid and groupid
#      emd is running under and the groups the userid belongs to. The
#      ulimit for the emd process.
#
#      The output is of the form emresult=username|groupname|group1,group2
#          Where username is the name of the user, groupname is the name
#          of the group the username belongs to and group1, group2 are the
#          other groups the username belongs to (incl. groupname)
#     
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    xxu         12/28/04 - fix bug 3407837. 
#    njagathe    11/24/04 - Handle NT 
#    kduvvuri    09/17/04 - fix syntax error. 
#    kduvvuri    09/15/04 - add tracing. 
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    dmshah      05/23/02 - Fixing error case in group where the user is in a single group
#    dmshah      04/03/02 - dmshah_support_host_metris
#    dmshah      04/03/02 - PWD part of emdinfo
#    dmshah      04/02/02 - Creation
#

require "emd_common.pl";
require "semd_common.pl";

my $uid    = "";
my $gid    = "";
my $groups = "";

my $os = get_osType();
my $rc = 0;
if ( $os eq "WIN" )
{
  if (defined( $ENV{ORACLE_HOME} )) 
  { 
    $rc = 0xffff & system("$ENV{ORACLE_HOME}/bin/nmupm emdinfo");
    $rc >>= 8;
  }
  if ( $rc != 0 )
  {
    EMD_PERL_DEBUG("unable to execute $ENV{ORACLE_HOME}/bin/nmupm emdinfo");
    print "em_result=$uid|$gid|$groups|$ENV{ORACLE_HOME}\n";
  }
  exit($rc);
}

#Rest of the code is for non windows.
$ENV{PATH} = "/bin:/usr/bin:/usr/sbin:/usr/lib:/etc";

chomp($idinfo = `id`);

EMD_PERL_DEBUG("The command id returned: $idinfo");

@DATA=split(/[\s+]/, $idinfo);
foreach $line (@DATA)
{
  EMD_PERL_DEBUG("Processing token: $line");
  if($line =~ /uid/)
  {
      my( $discard, $rest) = split(/[=]/,$line);
      ( $discard, $uid) = split(/[()]/,$rest);
  }
  elsif ($line =~ /gid/)
  {
      my( $discard, $rest) = split(/[=]/,$line);
      ( $discard, $gid) = split(/[()]/,$rest);
  }
  elsif ($line =~ /groups/)
  {
      my( $discard, $rest) = split(/[=]/,$line);
      @GROUPS=split(/[,]/, $rest);
      foreach $groupinfo (@GROUPS)
      {
          my( $discard, $group) = split(/[()]/,$groupinfo);
          $groups = $groups . "," . $group;
       }
       $groups =~ s/,$//;
  }
}

EMD_PERL_DEBUG("uid=$uid,gid=$gid,groups=$groups,ORACLE_HOME=$ENV{ORACLE_HOME}");
print "em_result=$uid|$gid|$groups|$ENV{ORACLE_HOME}\n";

