#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/emrepDbAssoc.pl /main/1 2009/06/15 06:42:41 rstorrie Exp $
#
# emrepDbAssoc.pl
# 
# Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      emrepDbAssoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rstorrie    06/12/09 - Check for undef crossHost
#    rstorrie    06/10/09 - Take account of OCM_CROSS_HOST to determine if its
#                           RAC
#    rstorrie    06/09/09 - Add Metric and MetricColumnCount env settings
#    rstorrie    06/05/09 - Script the creates the association between the
#                           emrep target and the db instance
#    rstorrie    06/05/09 - Creation
# 
use strict;
use ecmAssoc;
use File::Spec;
use encoding 'utf8';

require "$ENV{EMDROOT}/sysman/admin/scripts/emd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/ccr/ccr_common.pl";

my ($configFile, $machine, $crossHost) = @ARGV;

my $oracleHome = $ENV{ORACLE_HOME};
my $metric = "emrep_dbAssoc";
my $columnCount = 1;
my $sid = "";
my $dbName = "";

# Check if crossHost is undef, this can occur is 
# the emrep target was instrumented pre crossHost
if (! defined($crossHost))
{
  $crossHost = "NO";
}

# Make a call to handleConfigMetricResult but pass in the address of
# the local routinr getResult
handleConfigMetricResult($configFile,$metric,$columnCount,$sid,\&getResult);

# If the configMetricResult did no find the value then extract
# it from the filename of the ll file
if ($dbName eq "" )
{
  $configFile =~ /.*\/(.*)db.emrep$/;
  $dbName = $1;
}
else {
  $dbName =~ s/^em_result=//;
}

# Check if OCM_CROSS_HOST is set to YES, if so its a RAC database
# if no then return a normal database type
if ($crossHost eq "YES")
{
  print ("em_result=$ecmAssoc::CONNECTS_TO||$ecmAssoc::RAC_DATABASE_TYPE|$machine:$dbName:$oracleHome\n");
}
else {
  print ("em_result=$ecmAssoc::CONNECTS_TO||$ecmAssoc::ORACLE_DATABASE_TYPE|$machine:$dbName:$oracleHome\n");
}

# This assumes that only one row is returned, it will get the last 
# row if multiple rows are returned
sub getResult
{
  my ($result) = @_;

  if(length($result) != 0)
  {
    $dbName = $result;
  }
}
