# insert the commands you wish to execute when eml fails to stay running. 
#
#
# Mail to specified user
#
#  The message text is passed in as the first parameter. 
#  The subject is passed in as the optional second parameter.  Default subject is 'Enterprise Manager is down'
#

use strict;
use Oraperl;
use Time::HiRes;

require "emd_common.pl";
require "semd_common.pl";

sub send_mailx
{
  my $start_time = Time::HiRes::time;
  my $targetname = "$ENV{EM_REPOS_USER}1234";
  my $fn = get_tmp_filename ($targetname, "emrepdown");
  EMD_PERL_DEBUG("emrepdown: opened $fn");
  system "date > $fn";
  if(!open(FH, ">>$fn")) 
  {
    EMD_PERL_ERROR("emrepdown: Could not open $fn for error messages");
  }
  my $subject="Enterprise Manager is Down";
  if ($#ARGV+1 > 0) 
  {
    if ($#ARGV+1 > 1) 
    {
      print FH "$ARGV[1]\n";
      print FH "Error message: ";
      print FH "$ARGV[0]\n";
      $subject=$ARGV[1]; 
    } 
    else 
    {
      print FH "Enterprise Manager is down.\n";
      print FH "Error message: ";
      print FH "$ARGV[0]\n";
    }
  } 
  else 
  {
    print FH "Enterprise Manager is down.\n";
    print FH ".\n";
  }

  EMD_PERL_DEBUG("emrepdown: 1");
  if(!close FH) 
  {
    EMD_PERL_ERROR("Could not close $fn");
  }

  my $filename="../sysman/config/emd.properties";
  if ( $ENV{EMDROOT} ne "" ) 
  {
    $filename="$ENV{EMDROOT}/sysman/config/emd.properties";
  }

  EMD_PERL_DEBUG("emrepdown: 2");
  my $command1="cat $filename | grep 'emd_email_address=' | grep -v '#' | sed s/emd_email_address=// | awk '{print $1}'";
  EMD_PERL_DEBUG ("emrepdown: list command1=$command1");
  my $list=`$command1` or EMD_PERL_ERROR("emd_email_address is not correctly defined in $filename");
  $command1="cat $filename | grep 'emd_from_email_address=' | grep -v '#' | sed s/emd_from_email_address=// | awk '{print $1}'";
  EMD_PERL_DEBUG ("emrepdown: return command1=$command1");
  my $return=`$command1` or EMD_PERL_WARN("emd_from_email_address is not correctly defined in $filename");
  my $out;
  chomp($return);
  chomp($list);
  EMD_PERL_DEBUG ("emrepdown: list=$list");
  EMD_PERL_DEBUG ("emrepdoen: return=$return");

  my $platform = get_osType();
  if ( "$list" ne "" ) 
  {
    if ($platform eq "LNX" )
    {
       $command1 = "`mail -s \"$subject\" $list \< $fn`";
       EMD_PERL_DEBUG("emrepdown: command1=$command1");
       system $command1;
    }
    else
    {
       if ("$return" eq "" ) 
       {
           $command1 = "`mailx -s \"$subject\" $list \< $fn`";
           EMD_PERL_DEBUG("emrepdown: command1=$command1");
           system $command1;
       } 
       else 
       {
           $command1 = "`mailx -s \"$subject\" -r $return $list < $fn`";
           EMD_PERL_DEBUG("emrepdown: command1=$command1");
           system $command1;
       }
    }
  }
  $out = `rm $fn`;
  if ( "$out" ne "" ) 
  {
    EMD_PERL_WARN("emrepdown: ERROR $out removing $fn");
  }
}

#  Fix for Bug 3734726
my $platform = get_osType();

if(($platform eq "SOL") ||
   ($platform eq "HP") ||
   ($platform eq "AIX") ||
   ($platform eq "LNX") ||
   ($platform eq "OSF1"))
{
  send_mailx();  
}
else
{
  EMD_PERL_ERROR("emrepdown: Platform $platform does not support mailx.");
}
