#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/emsystem_assoc.pl /main/9 2009/09/24 07:43:04 aghanti Exp $
#
# emsystem_assoc.pl
# 
# Copyright (c) 2006, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      emsystem_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rstorrie    06/22/09 - Addition of DEFINED_BY for system
#    rstorrie    06/16/09 - Fix perl and columnn order for bug 8602916
#    aghanti     05/26/09 - Open the emrep collection file in proper encoding
#    rstorrie    12/03/08 - Change the output so that the sysem name is a
#                           target property rather than the targetname
#    jsutton     06/10/08 - Check OCM_CROSS_HOST value to see if this is a RAC
#    pparida     10/01/07 - Fix bug 6450736: Change all assoc types to
#                           "contains".
#    rstorrie    09/18/06 - Addition of the hostname to the repository target
#                           to increase the chances it is unique
#    rstorrie    09/06/06 - Modify script to join oms_name and oracle_home for
#                           relationship by ? character
#    rstorrie    08/24/06 - Removal of ? for separator, switch to the sql
#                           output
#    rstorrie    08/24/06 - Associations for the EM system target
#    rstorrie    08/24/06 - Creation
# 

use strict;
use ecmAssoc;
use File::Spec;

require "$ENV{EMDROOT}/sysman/admin/scripts/ccr/ccr_common.pl";

my $configFile = shift;
my $hostName = shift;

if (!defined $configFile )
{
    print STDERR "em_error=The emrep collection file not passed.\n";
    exit (-1);
}

if( !(-f $configFile))
{
    print STDERR "em_error=The emrep collection file \"$configFile\" was not found.\n";
    exit (-1);
}

# main
# call parsecollect with all 3 target types

my ($CONFIG_FILE_READER, $line);
my @configLines=();

#Get the db charset and map it to corresponding perl encoding
my $llOpenMode = getLLFileOpenMode($configFile);

if(open(CONFIG_FILE_READER, $llOpenMode, $configFile))
{
    @configLines = <CONFIG_FILE_READER>;
    close(CONFIG_FILE_READER);
}

parseCollection(\@configLines,'emrep_omsname','oracle_oms');
parseCollection(\@configLines,'emrep_agents','oracle_emd');
parseCollection(\@configLines,'emrep_beacons','oracle_beacon');

#print the repository membership 
my $file = File::Spec->splitpath($configFile);
${file}=~ /^(.*).emrep$/;
my $filename = $1;
$filename=~ /(.*)db$/;

my $ocmCrossHost = "FALSE";
my $ocmCrossHostFound = 0;
foreach $line (@configLines)
{
    if ($line =~ /OCM_CROSS_HOST/)
    {
        (undef,$ocmCrossHost) = split(/=/, $line);
        $ocmCrossHostFound = 1;
        last;
    }
}
if (!$ocmCrossHostFound || $ocmCrossHost ne "YES")
{
    print "em_result=".$ecmAssoc::CONTAINS."||oracle_database|".$hostName.":".$1."\n";
}
else
{
    print "em_result=".$ecmAssoc::CONTAINS."||rac_database|".$hostName.":".$1."\n";
}

# Print a definfed_by for the em_system, this will be made up
# of the DBNAME_emrep and its defined by a oracle_emrep target

print "em_result=".$ecmAssoc::DEFINED_BY."|".$1."_emrep|oracle_emrep||\n";

# Sub for printing the collection details
sub parseCollection
{
    my $configLines = shift;
    my $metric = shift;
    my $targetType=shift;
    my $found=0;

    my $line;
    my $endMarker;
    my $lastResult = '';
    foreach $line (@{$configLines})
    {
        chomp($line);
        if($found)
        {
            if ($line =~ /^$endMarker/)
            {
                last; # found the metric end, exit the loop
            }
            else
            {
                if($line =~ /^\s*em_result=\s*(.*)|(.*)/)
                {
                    ${line}=~ m/^\s*em_result\s*=\s*(.+?)\|(.+?)$/;
                    # if we have a oracle_home then print and create 
                    # the oms target association
                    if (defined $2 && $2 ne "")
                    {
                        print "em_result=".$ecmAssoc::CONTAINS."|"."|".$targetType."|".$1."?".$2."\n";
                        $lastResult=$1.$2;
                    }
                    # otherwise print the target name, type
                    else
                    {
                        print "em_result=".$ecmAssoc::CONTAINS."|".$1."|".$targetType."|\n";
                        $lastResult=$1;
                    }
                }
                else
                {
                    #Append the last result with
                    #this line using a space character.
                    $lastResult= $lastResult . " " . $line;
                }
            }
        }
        else
        {
            if ($line =~ /^$metric(.*):Begin/)
            {
                #Found the metric start,
                $found = 1;
                $endMarker = "$metric:End";
                next;
            }
        }
    } # End foreach
} # End sub
