#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/epm/epm_metrics.pl /main/2 2009/08/10 12:05:42 rbalan Exp $
#
# epm_metrics.pl
# 
# Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      epm_metrics.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nunni       07/01/09 - config metrics collection script for epm products
#    nunni       07/01/09 - Creation
# 

use strict;
require "$ENV{EPM_ORACLE_HOME}/ccr/sysman/admin/scripts/semd_common.pl";

my $numArgs = $#ARGV + 1;
my $debug = 0;
my $filesep = "/";
my $pathsep;
my $javaPath;
my @cpArr;
my $componentId;
my $metricType;

# Variables for path 
my $mw_home;
my $epm_ora_home;
my $epm_ora_instance;
my $epm_ocm_jar;
my $epm_version;
my $reqd_version = "11.1.2.0";

$mw_home = $ENV{MW_HOME};
$epm_ora_home = $ENV{EPM_ORACLE_HOME};
$epm_ora_instance = $ENV{EPM_ORACLE_INSTANCE};
$epm_ocm_jar = $ENV{EPM_OCM_JAR};

$javaPath = $ENV{EPM_JAVA};
$epm_version = $ENV{EPM_VERSION};

if ( get_osType() eq 'WIN' ) {
    $pathsep = ";";
}
else {
    $pathsep = ":";
}

if($numArgs < 2) {
    die "Insufficient Arguments to epm_discovery\n"; 
}



$componentId = $ARGV[0];
$metricType = $ARGV[1];


if($debug == 1) {
    print "componentId = $componentId\n";
    print "metricType = $metricType\n";
    print "mw_home = $mw_home\n";
    print "epm_ora_home = $epm_ora_home\n";
    print "epm_ora_instance = $epm_ora_instance\n";
}

# Setting java
if ( !defined $javaPath || $javaPath eq "" ) 
{
	die "Unable to get a valid java executable";
}


if( $epm_version eq $reqd_version )
{
	@cpArr = (
	    join($filesep, $epm_ora_home, "common", "jlib", $reqd_version, "epm_j2se.jar"),    
       	$epm_ocm_jar 
        );
}
else
{
	die "Only version 11.1.2.0 supported\n";
}

my $classpath = join ($pathsep, @cpArr);         

my $command = "$javaPath -classpath $classpath -DMW_HOME=$mw_home -DORACLE_INSTANCE=$epm_ora_instance -DEPM_ORACLE_INSTANCE=$epm_ora_instance -DEPM_ORACLE_HOME=$epm_ora_home oracle.ocm.epm.metrics.EPMCollector $componentId $metricType" ;


if($debug == 1) {
    print "Command = $command\n";
}

my @epm_metrics;
my $epm_metric_line;
chomp(@epm_metrics = qx!$command!);


if ($? > 0 )
{
    if($debug == 1 ) {
        print "The following command failed : $command. Error Code : $?";
    }
}
else
{
    foreach $epm_metric_line (@epm_metrics)
    {
        print "$epm_metric_line\n";
    }
}
