#!/usr/local/bin/perl
# 
# $Header: esa_config.pl 23-sep-2005.15:54:39 dsukhwal Exp $
#
# esa_config.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      esa_config.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    dsukhwal    09/21/05 - add bulk sub 
#    dkjain      05/12/05 - dkjain_bug-4360523_main
#    dkjain      05/11/05 - Creation
# 
use strict ;
require "emd_common.pl";

#return zero when max count is zero
#return zero when no value is specified for a policy 
sub get_max_upload_rowcount(){

 my ($targetType,$policyName) = @_;
 my $propertiesFile ;
 my @info ;
 my $line ;
 my $maxCount = 0;
 my $agentOHome = $ENV{'ORACLE_HOME'};
 $propertiesFile = "$agentOHome/sysman/config/esa/$targetType.properties";

 unless (open ( FILE, $propertiesFile)){
   #If file is missing, upload no data. 
   #print some log to indicate file is missing.
  EMD_PERL_ERROR("File $propertiesFile was not found at location $agentOHome/sysman/config/esa");
   return 0;
 }

 my @valueResult ;
 my $len ;
 @info = <FILE> ;
 foreach $line (@info){
  if(($line =~ /^\s*$policyName(.*)/)){
       @valueResult = split(/=/,$line);
       $len = @valueResult ;
       if(($len < 2)||($len > 2)){
        EMD_PERL_ERROR("Max Count Value for the Policy $policyName not set properly"); 
        $maxCount = 0 ;
       }
       elsif($policyName eq trim($valueResult[0])){
         $maxCount = validate_max_count(trim($valueResult[1]),$policyName);
       }
       else{
        EMD_PERL_ERROR("Max Count Value for the Policy $policyName not set properly"); 
        $maxCount = 0 ;
       }
       last ;
   }
 }
 return $maxCount ;
}


sub get_max_upload_rowcount_bulk{
 my $targetType = shift;
 my @policyList = @_;
 my %maxCountHash;
 my $propertiesFile ;
 my @info ;
 my $line ;
 my $line_num=0;
 my $maxCount = 0;
 my $agentOHome = $ENV{'ORACLE_HOME'};
 $propertiesFile = "$agentOHome/sysman/config/esa/$targetType.properties";

 unless (open ( FILE, $propertiesFile)){
   #If file is missing, upload no data. 
   #print some log to indicate file is missing.
  EMD_PERL_ERROR("File $propertiesFile was not found at location $agentOHome/sysman/config/esa");
   return 0;
 }

 my @valueResult ;
 my $len ;
 @info = <FILE> ;
 close FILE;
 foreach $line (@info){
   $line_num++;
   @valueResult = split(/=/,$line);
   $len = @valueResult ;
   if(($len < 2)||($len > 2)){
    EMD_PERL_ERROR("Max Count Value not set properly in file $propertiesFile line no. $line_num"); 
   }
   else{
		$maxCountHash{trim($valueResult[0])} = validate_max_count(trim($valueResult[1]),trim($valueResult[0]));
	}
  }	
  return %maxCountHash;
}


sub trim
{
  my $origStr = $_[0];
  #Strip trailing and leading
  $origStr =~ s/^\s*|\s*$//g;
  return $origStr;
}

sub validate_max_count(){
 my ($maxCount,$policyName) = @_ ;
 my @valueResult = split(/ /,$maxCount);
 my $lenArray = @valueResult ;
 if(($lenArray > 1)||($maxCount =~ m/[^0-9]/)||($maxCount eq "")){ 
    if($maxCount eq "All"){
      return "-1" ;
    }
    EMD_PERL_ERROR("Max Count Value for the Policy $policyName not set properly:maxCount:$maxCount"); 
    return 0;
 }
 else{    #if $maxCount contains digits only
    return $maxCount;
 }
}

1;

