# $Header: filesystems.pl 13-oct-2004.10:29:20 sacgoyal Exp $
#
# filesystems.pl
# 
# Copyright (c) 2001, 2004, Oracle. All rights reserved.  
#
#    NAME
#      filesystems.pl 
#
#    DESCRIPTION
#      This file generates output about the filesystems on the system in
#      the followign format:
#      em_result=<file_sys_name>|<size of file system>| \
#                <space used>| \
#                <space available for file creation by nonpriv users>| \
#                <% available>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    sacgoyal    10/13/04 - 
#    skumar      08/12/04 - use hostGenFunctions
#    skumar      02/02/04 - Creation
# 


use hostGenFunctions;
use strict;

my @diskinfo;
my %diskCaps = ();
my @fields = ();
my $line;
my $usedpct;

my $mntpt;
my $dev;
my $totalkb;
my $usedkb;
my $availkb;

# dev totalkb usedkb availkb usedpct mntpt
@diskinfo = getDiskInfo();

foreach $line (@diskinfo)
{
  @fields = split(m/[\n\t\s]+/, $line);
  $dev = $fields[0];
  $totalkb = $fields[1];
  next if defined $diskCaps{$dev}; # skip duplicate entries
  $diskCaps{$dev} = $totalkb;

  $usedkb = $fields[2];
  $availkb = $fields[3];
  $usedpct = $fields[4];
  $mntpt = $fields[5];
  $usedpct =~ s/%//;

  printf "em_result=$mntpt|$dev|%.2f|%.2f|%.2f|%.2f\n",
         ($totalkb/1024, $usedkb/1024, $availkb/1024, 100-$usedpct);
}

exit 0
