#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/find_os.pl /main/1 2011/06/23 07:39:39 glavash Exp $
#
# find_os.pl
# 
# Copyright (c) 2009, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      find_os.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    glavash     04/07/11 - find os
#    mfidanbo    10/15/09 - Creation
#

sub get_osType
{
    my $os = $^O;

    if (( $os eq "Windows_NT") ||
        ( $os eq "MSWin32")) {
        return "WIN";
    }

    if (( $os eq "sunos" ) ||
        ( $os eq "solaris" )) {
        my $ver = `uname -r`;
        chomp($ver);
        if ( $ver !~ /^4\./ ) {
            return "SOL";
        }
    } elsif ( $os eq "hpux" ) {
        return "HP";
    } elsif ( $os eq "linux" ) {
        return "LNX";
    } elsif ( $os eq "aix" ) {
        return "AIX";
    } elsif ( $os eq "dec_osf" ) {
        return "OSF1";
    } elsif ( $os eq "darwin" ) {
        return "MAC OS X";
    }
        # Unsupported Operating System
        return -1;
}

1;
 
