#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/fmw/fmwUtil.pm /main/2 2012/09/24 22:01:25 navnkaur Exp $
#
# fmwUtil.pm
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      fmwUtil.pm - Utility script that can be used by middleware discovery/collection or such scripts. 
#
#    DESCRIPTION
#     This utility script can be used to:
#      - Check if the fmw install is the NG install
#      - Get the NG Oracle Home if it is NG install
#      - Get the location of weblogic domainlocation.properties file
#
#    NOTES
#     Important: If this utility is used in another perl script and that script uses "emd_common.pl",
#     it would have to be changed to use emdcommon.pm(which internally uses "emd_common.pl"). 
#     Also, the subroutines from emd_commmon.pl referred in the script would have to be fully declared 
#      e.g emdcommon::EMD_PERL_DEBUG
#
#
#    MODIFIED   (MM/DD/YY)
#    navnkaur    09/04/12 - Correcting the return
#    navnkaur    08/22/12 - Creating utility script
#    navnkaur    08/22/12 - Creation
# 

package fmw::fmwUtil;

use strict;
use Exporter 'import';

use File::Basename;
use File::Spec;
use emdcommon;

our @EXPORT = qw(
      isNGInstall
      getNGOracleHome
      getWLDomainLocFilePath
 );

#Checks if the fmw install is the NG install by checking if ccr directory is in oracle_common 
sub isNGInstall
{
  my $ngInstall = "N";
  my $ccrHome = getCCRHome();
  if($ccrHome)
  {
    my $ccrHomeDirLoc = dirname( $ccrHome );
    my $ccrHomeParentDir = basename($ccrHomeDirLoc);
    emdcommon::EMD_PERL_DEBUG("ccrHomeDirLoc ".$ccrHomeDirLoc );
    if($ccrHomeParentDir eq "oracle_common")
    {
      $ngInstall = "Y";
    }
  }  
  return $ngInstall;
}

#Returns the NG Oracle Home if it is NG Install
sub getNGOracleHome
{
  my $checkNGInstall = isNGInstall();
  my $oracleHomeDir;
  if($checkNGInstall eq "Y")
  {
    my $ccrHome = getCCRHome();
    my $upDirectory = dirname($ccrHome);
    $oracleHomeDir = dirname($upDirectory);
    emdcommon::EMD_PERL_DEBUG("Oracle Home ".$oracleHomeDir);
  }
  else #not NG install
  {
    emdcommon::EMD_PERL_DEBUG("Not an NG install");
  }
  return $oracleHomeDir;
}

#location of domainlocation.properties file
sub getWLDomainLocFilePath
{
  my $ccrHome = getCCRHome();
  return $ccrHome;
}

#Returns the CCR home
sub getCCRHome
{
  my $ccrHome = $ENV{CCR_HOME};
  if (!defined($ccrHome))
  {
    emdcommon::EMD_PERL_DEBUG("No CCR_HOME defined");
    return ();
  }
  emdcommon::EMD_PERL_DEBUG("CCR_HOME ".$ccrHome);
  return $ccrHome;
}

return 1;
