#!/usr/local/bin/perl
#
# Copyright (c) 1998, 2005, Oracle. All rights reserved.  
#
# NAME:
#
#  frminit.pl -- platform specific init file
#
# ARGUMENTS:
#
#  none
#
# RETURNS:
#
#  none
#
# MODIFIED     (MM/DD/YY)
#  sbalacha     09/23/05  - #(3334946) Merge changes from 10.1.2 Linux 
#  sbalacha     08/03/05  - #(4292009) Executable names changes so that 
#                           central agent can monitor different versions 
#                           of targets
#  nudupi       06/02/05  - #(4352096) Changed the value of getcpuCPU_COL so 
#                           that the correct value of cpu usage is retreived 
#                           from ps output. 
#  sbalacha     04/27/05  - #(4309317) Fix illegal division by zero error 
#  ahousing     01/26/05  - #(4138702) Update copyright date 
#  sbalacha     12/01/04  - #(4017604) remove references to dejvm90 
#  sbalacha     09/23/04  - #(3008239) Write forms_em.log to $TMPDIR or $TMP
#  sbalacha     07/25/04  - #(3788206) merge for HP-UX for 10.1.2 hpunix32 rel. 
#  ahousing     02/18/04  - #(3452847) Remove "9"'s from user visible spots 
#  clowes       04/01/04  - #(3491561) Adding Linux fix to generic line to avoid
#                           regressions in future releases
#  dklein       02/25/03 -  Added dejvmexename
#  clowes       10/14/03 -  #(3189785) get_oc4j_pid now allows for re-parenting of
#                           OC4J_BI_Forms process to root 
#  clowes       09/09/03 -  #(3133205) and #(3122105) Substantial changes to 
#                           accomodate Linux
#  clowes       08/21/03 -  #(3108671) port specific calls moved to formsinit.pl
#                           from formsproc.pl and formsload.pl
#  clowes       07/09/03 -  slight change to ps command arguments
#  clowes       06/17/03 -  subroutines for reworked formsload.pl, formsproc.pl
#  clowes       06/17/03 -  subroutines for FormsProcessInfo.pl
#  diglesia     04/24/02 -  HPUX-Changes for iAS 2.0 Forms/Reports 9i M17F APR12
#                           Tick Fix for bug:   BUG 2337917 - FORMS SESSION
#                           DETAILS DOES NOT                 SHOW IN EMD
#  sindla       03/07/02 -  add 1; at the end of the file as it was 
#                           reporting an error in the shiphome that
#                           this file is not returning true. 
#  sindla       08/12/01 -  added emHome
#  pkuhn        08/09/01 -  Changed from .tcl to .pl
#  sindla       08/01/01 -  Creation
#
#
# debug flag (0 or 1)
#
$frm_debug_flag = 0;
my @forms_processes = ();
my @oc4j_processes = ();
my $PID_COL;
my $COMM_COL= "-1";
my $perl_exec = $^X;
#
# set some platform-specific variables
#
chomp ($os = `uname -s`) or die "Failed to run the uname command";
if($os eq "HP-UX") {
  $ENV{UNIX95} = "XPG4";
  $pgsize=`getconf SC_PAGE_SIZE`;
}
$lnrexename = "f60srvm";
my $version = getVersion($frm_orahome);
if ( $version =~ /^10.1.2/ )
{
  $frmexename = "frmweb";
  $dejvmexename = "dejvm";
}
elsif ($version =~ /9\.0\.4\.[2-9]/)
{
  $frmexename = "f90webm";
  $dejvmexename = "dejvm90";
}
else
{
  $frmexename = "f90webm";
}
$emhome = "/forms/em";
$src = "/usr/bin/csh";
$setenv_format = "setenv %s %s";
$killcommand = "kill -9";
$logcommand = "kill";

if ( $os eq "HP-UX" ) 
{

  $PS = "/bin/ps -efx";
  $main::PID_COL = 0; 
  $main::COMM_COL = 4;

  $PS_SHORT = "/bin/ps -xo pid,ppid,args";
  $PS_FULL = "/bin/ps -A -xo pid,ppid,args";
  $DATA_LINE = 1;

  $rti_ps_command = "/bin/ps -e -o comm,pid,sz,pcpu";
  $getmemusage = "/bin/ps -e -o comm,pid,sz";
  $getcpuusage = "/bin/ps -e -o comm,pid,sz,pcpu";
}
elsif ( $os eq "Linux" )
{
    $PS = "/bin/ps -axww";
    $main::PID_COL = 0; 
    $main::COMM_COL = 4;

    $PS_SHORT = "/bin/ps -o pid,ppid,comm";
    $PS_FULL = "/bin/ps -A -o pid,ppid,comm";
    $DATA_LINE = 1;

    $rti_ps_command = "/bin/ps -e -o fname,pid,pmem,pcpu";
    $getmemusage = "/bin/ps -e -o fname,pid,rss";
    $getcpuusage = "/bin/ps -e -o fname,pid,pmem,pcpu";
    $getcpuDelimiter = '\\s+';
    $getcpuPID_COL = "1";
    $getcpuCOMM_COL = "0";
    $getcpuCPU_COL = "3";

    ## Set PS_SHORT to include threads flag(-m) for RedHat 3.x
    $redhat_file = "/etc/redhat-release" ;
    if ( -r $redhat_file )
    {
      $verStr=`/bin/rpm -qf /etc/redhat-release --qf "%{VERSION}\n" 2>/dev/null`;
      if ( index($verStr,"3") == 0 && (index($verStr,"AS") != -1 || index($verStr,"ES") != -1 ) )
      {
        $PS_SHORT = "/bin/ps -o pid,ppid,comm -mf";
      }
    }

}
elsif ( $os eq "SunOS" )
{
    $PS = "/usr/ucb/ps -axww";
    $main::PID_COL = 0; 
    $main::COMM_COL = 4; 

    $PS_SHORT = "/bin/ps -o pid,ppid,comm";
    $PS_FULL = "/usr/bin/ps -e -o pid,ppid,comm";
    $DATA_LINE = 1;
 
    $rti_ps_command = "/bin/ps -e -o fname,pid,pmem,pcpu";
    $getmemusage = "/bin/ps -e -o fname,pid,rss";
    $getcpuusage = "/bin/ps -e -o fname,pid,pmem,pcpu";
    $getcpuDelimiter = '\\s+';
    $getcpuPID_COL = "1";
    $getcpuCOMM_COL = "0";
    $getcpuCPU_COL = "3";
}
else
{
    $PS = "/bin/ps -axww";
    $main::PID_COL = 0; 
    $main::COMM_COL = 4;
    
    $PS_SHORT = "/bin/ps -o pid,ppid,comm";
    $PS_FULL = "/bin/ps -A -o pid,ppid,comm";
    $DATA_LINE = 1;

    $rti_ps_command = "ps -e -o fname,pid,pmem,pcpu";
    $getmemusage = "ps -e -o fname,pid,rss";
    $getcpuusage = "ps -e -o fname,pid,pmem,pcpu";
}
$bin = "bin";
$pathsep = "/";


#
# log an entry to a pre-defined log file
#
$tmpdir = $ENV{"TMPDIR"};
if ( $tmpdir eq "" )
{
    $tmpdir = $ENV{"TMP"};
}
if ( $tmpdir eq "" )
{
    $tmpdir = "/tmp";
}
sub frmdebug {
    if ($frm_debug_flag) {
        $frm_logfile = $tmpdir . "/forms_em.log";
        open(LOGFILE, ">>$frm_logfile");
        print LOGFILE "$_[0]\n";
        close(LOGFILE);
    }
}

#
# get_oc4j_pid()
#
# set up the command to return the candidate oc4j processes
#
# parameters: String "oc4j.jar"
#             String "OC$J_BI_Forms"
#             String "$ORACLE_HOME"
# Called from: FormsProcessInfo.pl
#
sub get_oc4j_pid {
    my $oc4j_pid_ps = `$PS | grep "$_[0]" | grep "$_[1]" | grep "$_[2]"`;
    my @oc4j_pid = split ( "\n", $oc4j_pid_ps);
    my @oc4jInfo;
    my $line;
 
    foreach $line (@oc4j_pid)
    {
        @oc4jInfo = split ( " ", $line);
        if ( $os eq "HP-UX" ) 
        {
            $oc4jPid = "$oc4jInfo[1]";
        } 
        else
        {
            $oc4jPid = "$oc4jInfo[0]";
        }
        $newOc4jPid = $oc4jPid;
        $oc4jContinueLoop = "true";
        $oc4jProcess_ps = `$PS_SHORT -p "$oc4jPid"`;
        @process_output_lines = split("\n", $oc4jProcess_ps);	 
        @oc4jProcess = split(" ", $process_output_lines[$DATA_LINE]);

        $oc4jPid = $oc4jProcess[0];
        $parentPid = $oc4jProcess[1];
        $comm = $oc4jProcess[2];
        $newPid = $oc4jPid;

        while ( $oc4jContinueLoop eq "true" )
        {
            #
            # #(3189785)
            # Parent process of OC4J_BI_Forms process can be root as well as opmn
            #
            if ( index($comm,"opmn") != -1 || $parentPid == 1 )
            {
                $oc4jContinueLoop = "false";
                push (@main::oc4j_processes,$oc4jPid);
                return;
            }
            else
            {
                if ( index($comm,"java") != -1 )
                {
                    $oc4jPid = $newPid;
                    $parentProcess_ps = `$PS_SHORT -p $parentPid`;
                    @process_output_lines = split("\n", $parentProcess_ps);	                        
                    @parentProcess = split(" ", $process_output_lines[$DATA_LINE]);
                    $newPid = $parentProccess[0]; 
                    $parentPid = $parentProcess[1];
                    $comm = $parentProcess[2];
                }
                else 
                {
                    # 
                    # we can't include this oc4jprocess
                    # as it does not appear to be managed
                    # part of the opmn process tree
                    $oc4jContinueLoop = "false";
                } 

            } # if parent process is managed by opmn

        }  # while we have a valid parent process

    } #foreach candidate oc4j process
    
}

#
# get_forms_pids()
#
# set up the command to return the forms processes
#
# parameters: String oc4j process pid
#             String forms executable name
# Called from: FormsProcessInfo.pl
#
sub get_forms_pids {
    my $line;
    $oc4jPid = $_[0];
    $orahome = $_[1]; 
    $frmExeName = $_[2];

    my $formsProcess_ps = `$PS_FULL | grep "$frmExeName"`;
    my @formsProcess = split ( "\n", $formsProcess_ps);
    foreach $line (@formsProcess)
    {
        @formsInfo = split ( " ", $line);
        $formsPid = "$formsInfo[0]";
        $parentPid = "$formsInfo[1]";
        $comm      = "$formsInfo[2]";
        if ( index( $comm, $frmExeName ) != -1 )
        {
            $oc4jContinueLoop = "true";
            $parentProcess_ps = `$PS_SHORT -p "$parentPid"`;
            @process_output_lines = split("\n", $parentProcess_ps);
            @parentProcess = split(" ", $process_output_lines[$DATA_LINE]);

            $newParentPid = $parentProcess[1];
            $comm = $parentProcess[2];
 
            while ($parentPid != 1 && $oc4jContinueLoop eq "true")
            {
                if ( $parentPid eq $oc4jPid )
                {
                    push (@main::forms_processes,$formsPid);
                    $oc4jContinueLoop = "false";
                }
                else
                {
                    if ( index($comm, "java") != -1 )
                    {
                        $parentPid = $parentProcess[0];
                        $parentProcess_ps = `$PS_SHORT -p $newParentPid`;
                        @process_output_lines = split("\n", $parentProcess_ps);
                        @parentProcess = split(" ", $process_output_lines[$DATA_LINE]);

                        $newParentPid = $parentProcess[1];
                        $comm = $parentProcess[2];
                        
                    }
                    else 
                    {
                        # 
                        # we can't include this formsprocess
                        # as it does not appear to be managed
                        # by OC4J_BI_Forms
                        $oc4jContinueLoop = "false";   
                    } 

                } # if parent process is oc4j pid 

            }  # while the forms process has a parent

        } # we have a valid forms executable

    } #foreach candidate forms process
}

# Get the physical memory usage (%) for a set of pids.  
#
# Parameters:
#  pid_list - a comma separated list of pids to account for 
#  emdroot            - the root of the emd tree
# 
sub getPhysicalAndSharedMemory
{
  my $all_pids = shift(@_);
  my $emdroot = shift(@_);
  my @pid_list = split(",", $all_pids);
  my $totalPrivate = 0;
  my $maxShared = 0;
  my $private;
  my $shared;
  my $memUsage = 0;
  my $sharedUsage = 0;
  my $memoryPercent = 0;
  my $sharedPercent = 0;
  my $physical_mem_total = 0;
  my $physical_mem_free_raw = 0;
  my $pagesize = 0;

  my $memory_metrics = getPhysicalMemoryMetrics( $emdroot );

  ($physical_mem_total, $physical_mem_free_raw, $pagesize) =
    split( '\|', $memory_metrics );

  for my $i (0 .. $#pid_list)
  {
    # Call nmb and get the shared and private memory usage
    my $pmap_output = `$emdroot/bin/nmb $pid_list[$i] 2>&1`;

    # Make sure we don't get an error
    if( index( $pmap_output, "Error" ) == -1 ) 
    {

      # the output will be: {private-memory-in-kb} {shared-memory-in-kb}
      ($private, $shared) = split(  " ",  $pmap_output );
      # Add this to our totals
      $totalPrivate += $private;

      if( $shared > $maxShared ) {
        $maxShared = $shared;
      }      
    } # end if( index( ...
   
  } # end foreach

  # The total memory usage is SUM(private) + MAX(shared)
  $memUsage = $totalPrivate/1024;
  $sharedUsage = $maxShared/1024;

  if ( $physical_mem_total == 0 )
  {
      $memoryPercent = 0;
      $sharedPercent = 0;
  }
  else
  {
      $memoryPercent = $memUsage*100/$physical_mem_total;
      $sharedPercent = $sharedUsage*100/$physical_mem_total;
  }

  return "$memoryPercent|$sharedPercent";

}

sub getVersion
{
  my $oracle_home = shift(@_);
  my $script_output = `$perl_exec iasconfig.pl $oracle_home`;
  my ($first, $second) = split('\|', $script_output);
  my ($temp, $version) = split(/=/, $first);
  return $version;
}

1;
