#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/fusionapps/EnabledLanguages.pl /main/2 2010/07/16 16:40:42 vidykris Exp $
#
# emll/sysman/admin/scripts/fusionapps/EnabledLanguages.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      EnabledLanguages.pl - Enabled Languages for Fusion Applications
#
#    DESCRIPTION
#      This script is used to collect the Enabled Languages for fusion applications
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vidykris    06/04/10 - Creation
# 
use strict;
use File::Spec;
use ias::simpleXPath;

my ($appl_top,$pfName) = @ARGV;

# Get the functional setup file
my $appsFSFileName = File::Spec->catfile($appl_top, "fusionAppsFS.xml");
if ((-e $appsFSFileName) && (-r $appsFSFileName))
{
  my $appsFSFile = ias::simpleXPath::parseFile($appsFSFileName);
  
  # Get the languages
  my @languages = ias::simpleXPath::queryForAttributes($appsFSFile, 'ocm-collection-info/language');
  # Iterate through each offering and get the desired information
  foreach my $language (@languages)
  {
    my $languageCode = $language->{'language-code'};
    my $isInstalled = $language->{'is-installed'};
    
    # Print the em result for Languages
    print "em_result=$languageCode|$isInstalled\n"
  }
}
