#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/fusionapps/MultiTenancy.pl /main/2 2010/07/16 16:40:42 vidykris Exp $
#
# emll/sysman/admin/scripts/fusionapps/MultiTenancy.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      MultiTenancy.pl - Multi Tenancy for Fusion Applications
#
#    DESCRIPTION
#      This script is used to collect the Multi Tenancy information for fusion applications
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vidykris    06/04/10 - Creation
# 
use strict;
use File::Spec;
use ias::simpleXPath;

my ($appl_top,$pfName) = @ARGV;

# Get the functional setup file
my $appsFSFileName = File::Spec->catfile($appl_top, "fusionAppsFS.xml");
if ((-e $appsFSFileName) && (-r $appsFSFileName))
{
  my $appsFSFile = ias::simpleXPath::parseFile($appsFSFileName);
  
  # Get the multi tenancy flag
  my $multiTenancy = ((ias::simpleXPath::queryForAttributes($appsFSFile, 'ocm-collection-info/multi-tenancy'))[0])->{'is-multi-tenant'};
  
  # Print the em result for the Multi Tenancy Flag
  print "em_result=$multiTenancy\n";
}
